/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.model.AbstractModel;
import org.eclipse.persistence.tools.utility.model.value.ItemStateListValueModelAdapter;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.utility.model.value.SimpleListValueModel;
import org.eclipse.persistence.tools.utility.model.value.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.utility.model.value.SortedListValueModelWrapper;
import org.eclipse.persistence.tools.utility.tests.TestTools;
import org.eclipse.persistence.tools.utility.tests.model.value.CoordinatedList;

public class ItemStateListValueModelAdapterTests
extends TestCase {
    private Junk foo;
    private Junk bar;
    private Junk baz;
    private Junk joo;
    private Junk jar;
    private Junk jaz;
    private Junk tom;
    private Junk dick;
    private Junk harry;

    public ItemStateListValueModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.foo = new Junk("this.foo");
        this.bar = new Junk("this.bar");
        this.baz = new Junk("this.baz");
        this.joo = new Junk("this.joo");
        this.jar = new Junk("this.jar");
        this.jaz = new Junk("this.jaz");
        this.tom = new Junk("this.tom");
        this.dick = new Junk("this.dick");
        this.harry = new Junk("this.harry");
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testCollectionSynchronization() {
        SimpleCollectionValueModel<Junk> collectionHolder = this.buildCollectionHolder();
        ItemStateListValueModelAdapter listValueModel = new ItemStateListValueModelAdapter(collectionHolder);
        CoordinatedList<Junk> synchList = new CoordinatedList<Junk>((ListValueModel<Junk>)listValueModel);
        ItemStateListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        collectionHolder.add((Object)this.tom);
        collectionHolder.add((Object)this.dick);
        collectionHolder.add((Object)this.harry);
        ItemStateListValueModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        collectionHolder.remove((Object)this.foo);
        collectionHolder.remove((Object)this.jar);
        collectionHolder.remove((Object)this.harry);
        ItemStateListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
    }

    public void testListSynchronization() {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemStateListValueModelAdapter listValueModel = new ItemStateListValueModelAdapter(listHolder);
        CoordinatedList<Junk> synchList = new CoordinatedList<Junk>((ListValueModel<Junk>)listValueModel);
        ItemStateListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        listHolder.add(6, (Object)this.tom);
        listHolder.add(7, (Object)this.dick);
        listHolder.add(8, (Object)this.harry);
        ItemStateListValueModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        listHolder.remove(8);
        listHolder.remove(0);
        listHolder.remove(4);
        ItemStateListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
    }

    private void compare(ListValueModel<Junk> listValueModel, List<Junk> list) {
        ItemStateListValueModelAdapterTests.assertEquals((int)listValueModel.size(), (int)list.size());
        int i = 0;
        while (i < listValueModel.size()) {
            ItemStateListValueModelAdapterTests.assertEquals((Object)listValueModel.get(i), (Object)list.get(i));
            ++i;
        }
    }

    public void testCollectionSort() {
        this.verifyCollectionSort(null);
    }

    public void testListSort() {
        this.verifyListSort(null);
    }

    public void testCustomCollectionSort() {
        this.verifyCollectionSort(this.buildCustomComparator());
    }

    public void testCustomListSort() {
        this.verifyListSort(this.buildCustomComparator());
    }

    private Comparator<Junk> buildCustomComparator() {
        return new Comparator<Junk>(){

            @Override
            public int compare(Junk o1, Junk o2) {
                return o2.compareTo(o1);
            }
        };
    }

    private void verifyCollectionSort(Comparator<Junk> comparator) {
        SimpleCollectionValueModel<Junk> collectionHolder = this.buildCollectionHolder();
        ItemStateListValueModelAdapter listValueModel = new ItemStateListValueModelAdapter((ListValueModel)new SortedListValueModelAdapter(collectionHolder, comparator));
        CoordinatedList<Junk> synchList = new CoordinatedList<Junk>((ListValueModel<Junk>)listValueModel);
        ItemStateListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
        collectionHolder.add((Object)this.tom);
        collectionHolder.add((Object)this.dick);
        collectionHolder.add((Object)this.harry);
        ItemStateListValueModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
        collectionHolder.remove((Object)this.foo);
        collectionHolder.remove((Object)this.jar);
        collectionHolder.remove((Object)this.harry);
        ItemStateListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
    }

    private void verifyListSort(Comparator<Junk> comparator) {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemStateListValueModelAdapter listValueModel = new ItemStateListValueModelAdapter((ListValueModel)new SortedListValueModelWrapper(listHolder, comparator));
        CoordinatedList<Junk> synchList = new CoordinatedList<Junk>((ListValueModel<Junk>)listValueModel);
        ItemStateListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
        listHolder.add(0, (Object)this.tom);
        listHolder.add(0, (Object)this.dick);
        listHolder.add(0, (Object)this.harry);
        ItemStateListValueModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
        listHolder.remove(8);
        listHolder.remove(4);
        listHolder.remove(0);
        listHolder.remove(5);
        ItemStateListValueModelAdapterTests.assertEquals((int)5, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
    }

    private void compareSort(ListValueModel<Junk> listValueModel, List<Junk> list, Comparator<Junk> comparator) {
        TreeSet<Junk> ss = new TreeSet<Junk>(comparator);
        int i = 0;
        while (i < listValueModel.size()) {
            ss.add((Junk)listValueModel.get(i));
            ++i;
        }
        ItemStateListValueModelAdapterTests.assertEquals((int)ss.size(), (int)list.size());
        Iterator stream1 = ss.iterator();
        Iterator<Junk> stream2 = list.iterator();
        while (stream1.hasNext()) {
            ItemStateListValueModelAdapterTests.assertEquals(stream1.next(), (Object)stream2.next());
        }
    }

    public void testHasListeners() throws Exception {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemStateListValueModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemStateListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyStateChangeListeners());
        ItemStateListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyStateChangeListeners());
        ItemStateListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyStateChangeListeners());
        ItemStateListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyStateChangeListeners());
        ItemStateListValueModelAdapter listValueModel = new ItemStateListValueModelAdapter((ListValueModel)new SortedListValueModelWrapper(listHolder));
        ItemStateListValueModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemStateListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyStateChangeListeners());
        ItemStateListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyStateChangeListeners());
        ItemStateListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyStateChangeListeners());
        ItemStateListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyStateChangeListeners());
        this.verifyHasNoListeners((ListValueModel<Junk>)listValueModel);
        CoordinatedList synchList = new CoordinatedList(listValueModel);
        ItemStateListValueModelAdapterTests.assertTrue((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemStateListValueModelAdapterTests.assertTrue((boolean)this.foo.hasAnyStateChangeListeners());
        ItemStateListValueModelAdapterTests.assertTrue((boolean)this.foo.hasAnyStateChangeListeners());
        ItemStateListValueModelAdapterTests.assertTrue((boolean)this.jaz.hasAnyStateChangeListeners());
        ItemStateListValueModelAdapterTests.assertTrue((boolean)this.jaz.hasAnyStateChangeListeners());
        this.verifyHasListeners((ListValueModel<Junk>)listValueModel);
        listValueModel.removeListChangeListener("list values", synchList);
        ItemStateListValueModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemStateListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyStateChangeListeners());
        ItemStateListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyStateChangeListeners());
        ItemStateListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyStateChangeListeners());
        ItemStateListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyStateChangeListeners());
        this.verifyHasNoListeners((ListValueModel<Junk>)listValueModel);
    }

    public void testGetSize() throws Exception {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemStateListValueModelAdapter listValueModel = new ItemStateListValueModelAdapter((ListValueModel)new SortedListValueModelWrapper(listHolder));
        CoordinatedList synchList = new CoordinatedList(listValueModel);
        this.verifyHasListeners((ListValueModel<Junk>)listValueModel);
        ItemStateListValueModelAdapterTests.assertEquals((int)6, (int)listValueModel.size());
        ItemStateListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
    }

    public void testGet() throws Exception {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        SortedListValueModelWrapper listValueModel = new SortedListValueModelWrapper((ListValueModel)new ItemStateListValueModelAdapter(listHolder));
        CoordinatedList synchList = new CoordinatedList(listValueModel);
        this.verifyHasListeners((ListValueModel<Junk>)listValueModel);
        ItemStateListValueModelAdapterTests.assertEquals((Object)this.bar, (Object)listValueModel.get(0));
        ItemStateListValueModelAdapterTests.assertEquals((Object)this.bar, synchList.get(0));
        this.bar.setName("zzz");
        ItemStateListValueModelAdapterTests.assertEquals((Object)this.bar, (Object)listValueModel.get(5));
        ItemStateListValueModelAdapterTests.assertEquals((Object)this.bar, synchList.get(5));
        this.bar.setName("this.bar");
    }

    private void verifyHasNoListeners(ListValueModel<Junk> listValueModel) throws Exception {
        ItemStateListValueModelAdapterTests.assertTrue((boolean)((AbstractModel)listValueModel).hasNoListChangeListeners("list values"));
    }

    private void verifyHasListeners(ListValueModel<Junk> listValueModel) throws Exception {
        ItemStateListValueModelAdapterTests.assertTrue((boolean)((AbstractModel)listValueModel).hasAnyListChangeListeners("list values"));
    }

    private SimpleCollectionValueModel<Junk> buildCollectionHolder() {
        return new SimpleCollectionValueModel(this.buildCollection());
    }

    private Collection<Junk> buildCollection() {
        HashBag bag = new HashBag();
        this.populateCollection((Collection<Junk>)bag);
        return bag;
    }

    private SimpleListValueModel<Junk> buildListHolder() {
        return new SimpleListValueModel(this.buildList());
    }

    private List<Junk> buildList() {
        ArrayList<Junk> list = new ArrayList<Junk>();
        this.populateCollection(list);
        return list;
    }

    private void populateCollection(Collection<Junk> c) {
        c.add(this.foo);
        c.add(this.bar);
        c.add(this.baz);
        c.add(this.joo);
        c.add(this.jar);
        c.add(this.jaz);
    }

    private class Junk
    extends AbstractModel
    implements Comparable<Junk> {
        private String name;

        public Junk(String name) {
            this.name = name;
        }

        public void setName(String name) {
            this.name = name;
            this.fireStateChanged();
        }

        @Override
        public int compareTo(Junk j) {
            return this.name.compareTo(j.name);
        }

        public String toString() {
            return "Junk(" + this.name + ")";
        }
    }
}

