/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.AttributeOverride;
import org.eclipse.persistence.tools.mapping.orm.dom.Mapping;
import org.eclipse.persistence.tools.mapping.orm.dom.OptimisticLocking;
import org.eclipse.persistence.tools.mapping.orm.dom.PrimaryKey;
import org.eclipse.persistence.tools.mapping.orm.dom.WriteTransfomer;
import org.w3c.dom.Element;

final class EntityColumn
extends AbstractColumn
implements ExternalEntityColumn {
    private String elementName;
    private int index;
    static final String COLUMN = "column";
    static final String LENGTH = "length";
    static final String PRECISION = "precision";
    static final String SCALE = "scale";

    EntityColumn(AttributeOverride parent, int index) {
        super(parent);
        this.index = index;
        this.elementName = COLUMN;
    }

    EntityColumn(Mapping parent) {
        this(parent, COLUMN);
    }

    EntityColumn(Mapping parent, String elementName) {
        super(parent);
        this.index = -1;
        this.elementName = elementName;
    }

    EntityColumn(OptimisticLocking parent, String elementName, int index) {
        super(parent);
        this.index = index;
        this.elementName = elementName;
    }

    EntityColumn(PrimaryKey parent, int index) {
        super(parent);
        this.index = index;
        this.elementName = COLUMN;
    }

    EntityColumn(WriteTransfomer parent, int index) {
        super(parent);
        this.index = index;
        this.elementName = COLUMN;
    }

    @Override
    protected Element addSelf(String elementName, List<String> elementNamesOrder) {
        if (this.index == -1) {
            return super.addSelf(elementName, elementNamesOrder);
        }
        return this.addChild(this.getParent(), elementName, this.index, elementNamesOrder);
    }

    @Override
    public Element getElement() {
        if (this.index == -1) {
            return super.getElement();
        }
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return this.elementName;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Integer getLength() {
        return this.getIntegerAttribute(LENGTH);
    }

    @Override
    public Integer getPrecision() {
        return this.getIntegerAttribute(PRECISION);
    }

    @Override
    public Integer getScale() {
        return this.getIntegerAttribute(SCALE);
    }

    @Override
    public void removeSelf() {
        if (this.index == -1) {
            super.removeSelf();
        } else {
            this.removeChild(this.getParent(), this.getElementName(), this.index);
        }
    }

    @Override
    public void setLength(Integer length) {
        this.setAttribute(LENGTH, length);
        if (this.shouldRemoveEmptyElement() && !this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public void setPrecision(Integer precision) {
        this.setAttribute(PRECISION, precision);
        if (this.shouldRemoveEmptyElement() && !this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    public void setScale(Integer scale) {
        this.setAttribute(SCALE, scale);
        if (this.shouldRemoveEmptyElement() && !this.hasAnyChildren() && !this.hasAttributes()) {
            this.removeSelf();
        }
    }

    @Override
    boolean shouldRemoveEmptyElement() {
        return true;
    }
}

