/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.model;

import java.util.List;
import org.eclipse.persistence.tools.db.model.DatabaseTypeHandle;
import org.eclipse.persistence.tools.db.model.ELDatabase;
import org.eclipse.persistence.tools.db.model.ELModel;
import org.eclipse.persistence.tools.db.model.ELTable;
import org.eclipse.persistence.tools.db.model.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.db.model.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.db.model.platformsmodel.JavaTypeDeclaration;
import org.eclipse.persistence.tools.db.model.spi.ExternalColumn;
import org.eclipse.persistence.tools.utility.node.Node;

public final class ELColumn
extends ELModel {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    public static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    private DatabaseTypeHandle databaseTypeHandle;
    public static final String DATABASE_TYPE_PROPERTY = "databaseType";
    private volatile int size;
    public static final String SIZE_PROPERTY = "size";
    private volatile int subSize;
    public static final String SUB_SIZE_PROPERTY = "subSize";
    private volatile boolean allowsNull;
    public static final String ALLOWS_NULL_PROPERTY = "allowsNull";
    private volatile boolean unique;
    public static final String UNIQUE_PROPERTY = "unique";
    private volatile boolean primaryKey;
    public static final String PRIMARY_KEY_PROPERTY = "primaryKey";
    private volatile boolean identity;
    public static final String IDENTITY_PROPERTY = "identity";

    public static String parseTableNameFromQualifiedName(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return name.substring(0, index);
    }

    public static String parseColumnNameFromQualifiedName(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }

    public static boolean nameIsQualified(String columnName) {
        return columnName.indexOf(".") != -1;
    }

    ELColumn(ELTable table, String name) {
        super(table);
        this.name = name;
    }

    protected void initialize() {
        super.initialize();
        this.databaseTypeHandle = new DatabaseTypeHandle(this);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        DatabaseType dbType = this.defaultDatabaseType();
        this.databaseTypeHandle.setDatabaseType(dbType);
        this.size = dbType.requiresSize() ? dbType.getInitialSize() : 0;
        this.subSize = 0;
        this.allowsNull = dbType.allowsNull();
        this.unique = false;
        this.primaryKey = false;
        this.identity = false;
    }

    public ELTable getTable() {
        return this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.getTable().checkColumnName(name);
        String old = this.name;
        this.name = name;
        if (this.attributeValueHasChanged(old, name)) {
            this.firePropertyChanged(NAME_PROPERTY, old, name);
            this.qualifiedNameChanged();
        }
    }

    void qualifiedNameChanged() {
        String qName = this.qualifiedName();
        this.firePropertyChanged(QUALIFIED_NAME_PROPERTY, qName);
    }

    public DatabaseType getDatabaseType() {
        return this.databaseTypeHandle.getDatabaseType();
    }

    public void setDatabaseType(DatabaseType databaseType) {
        if (databaseType == null) {
            throw new NullPointerException();
        }
        DatabaseType old = this.databaseTypeHandle.getDatabaseType();
        this.databaseTypeHandle.setDatabaseType(databaseType);
        this.firePropertyChanged(DATABASE_TYPE_PROPERTY, (Object)old, (Object)databaseType);
        if (this.attributeValueHasChanged((Object)old, (Object)databaseType)) {
            this.synchronizeWithNewDatabaseType();
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (!this.getDatabaseType().allowsSize() && size != 0) {
            throw new IllegalArgumentException("size must be 0 when size is not allowed");
        }
        int old = this.size;
        this.size = size;
        this.firePropertyChanged(SIZE_PROPERTY, old, size);
    }

    public int getSubSize() {
        return this.subSize;
    }

    public void setSubSize(int subSize) {
        if (!this.getDatabaseType().allowsSubSize() && subSize != 0) {
            throw new IllegalArgumentException("sub-size must be 0 when sub-size is not allowed");
        }
        int old = this.subSize;
        this.subSize = subSize;
        this.firePropertyChanged(SUB_SIZE_PROPERTY, old, subSize);
    }

    public boolean allowsNull() {
        return this.allowsNull;
    }

    public void setAllowsNull(boolean allowsNull) {
        if (!this.getDatabaseType().allowsNull() && allowsNull) {
            throw new IllegalArgumentException("allows null must be false when allows null is not allowed");
        }
        boolean old = this.allowsNull;
        this.allowsNull = allowsNull;
        this.firePropertyChanged(ALLOWS_NULL_PROPERTY, old, allowsNull);
        if (allowsNull) {
            this.setPrimaryKey(false);
            this.setIdentity(false);
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        boolean old = this.unique;
        this.unique = unique;
        this.firePropertyChanged(UNIQUE_PROPERTY, old, unique);
        if (!unique) {
            this.setPrimaryKey(false);
        }
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        boolean old = this.primaryKey;
        this.primaryKey = primaryKey;
        this.firePropertyChanged(PRIMARY_KEY_PROPERTY, old, primaryKey);
        if (primaryKey) {
            this.setAllowsNull(false);
            this.setUnique(true);
        }
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setIdentity(boolean identity) {
        if (!this.supportsIdentityClause() && identity) {
            throw new IllegalArgumentException("the current platform does not support the IDENTITY clause");
        }
        boolean old = this.identity;
        this.identity = identity;
        this.firePropertyChanged(IDENTITY_PROPERTY, old, identity);
        if (identity) {
            this.setAllowsNull(false);
        }
    }

    public DatabasePlatform databasePlatform() {
        return this.getTable().databasePlatform();
    }

    public String qualifiedName() {
        return String.valueOf(this.getTable().qualifiedName()) + '.' + this.getName();
    }

    private DatabaseType defaultDatabaseType() {
        return this.databasePlatform().defaultDatabaseType();
    }

    public JavaTypeDeclaration javaTypeDeclaration() {
        return this.getDatabaseType().javaTypeDeclaration();
    }

    public boolean supportsIdentityClause() {
        return this.getDatabase().supportsIdentityClause();
    }

    protected void addChildrenTo(List<Node> children) {
        super.addChildrenTo(children);
        children.add(this.databaseTypeHandle);
    }

    public ELTable getParent() {
        return (ELTable)super.getParent();
    }

    public ELDatabase getDatabase() {
        return this.getParent().getParent();
    }

    void databasePlatformChanged() {
        this.setDatabaseType(this.databasePlatform().databaseTypeFor(this.getDatabaseType()));
    }

    private void synchronizeWithNewDatabaseType() {
        DatabaseType dbType = this.getDatabaseType();
        if (dbType.allowsSize()) {
            if (!dbType.allowsSubSize()) {
                this.setSubSize(0);
            }
            if (dbType.requiresSize()) {
                if (this.size == 0) {
                    this.setSize(dbType.getInitialSize());
                }
            } else if (this.subSize == 0) {
                this.setSize(0);
            }
        } else {
            this.setSize(0);
            this.setSubSize(0);
        }
        if (!dbType.allowsNull()) {
            this.setAllowsNull(false);
        }
        if (!dbType.getPlatform().supportsIdentityClause()) {
            this.setIdentity(false);
        }
    }

    void copySettingsFrom(ELColumn original) {
        this.setDatabaseType(original.getDatabaseType());
        this.setSize(original.getSize());
        this.setSubSize(original.getSubSize());
        this.setAllowsNull(original.allowsNull());
        this.setUnique(original.isUnique());
        this.setPrimaryKey(original.isPrimaryKey());
        this.setIdentity(original.isIdentity());
    }

    public String fieldName() {
        return this.qualifiedName();
    }

    void refresh(ExternalColumn externalColumn) {
        this.setDatabaseType(this.databaseTypeFrom(externalColumn));
        this.setSize(this.sizeFrom(externalColumn));
        this.setSubSize(this.subSizeFrom(externalColumn));
        this.setAllowsNull(this.allowsNullFrom(externalColumn));
        this.setPrimaryKey(externalColumn.isPrimaryKey());
    }

    private DatabaseType databaseTypeFrom(ExternalColumn externalColumn) {
        try {
            return this.databasePlatform().databaseTypeNamed(externalColumn.getTypeName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.databaseTypeFromJDBCTypeFrom(externalColumn);
        }
    }

    private DatabaseType databaseTypeFromJDBCTypeFrom(ExternalColumn externalColumn) {
        try {
            return this.databasePlatform().databaseTypeForJDBCTypeCode(externalColumn.getJDBCTypeCode());
        }
        catch (Exception exception) {
            return this.databasePlatform().defaultDatabaseType();
        }
    }

    private int sizeFrom(ExternalColumn externalColumn) {
        if (!this.getDatabaseType().allowsSize()) {
            return 0;
        }
        return externalColumn.getSize();
    }

    private int subSizeFrom(ExternalColumn externalColumn) {
        if (!this.getDatabaseType().allowsSubSize()) {
            return 0;
        }
        return externalColumn.getScale();
    }

    private boolean allowsNullFrom(ExternalColumn externalColumn) {
        if (!this.getDatabaseType().allowsNull()) {
            return false;
        }
        return externalColumn.isNullable();
    }

    @Override
    public String displayString() {
        return this.qualifiedName();
    }

    public void toString(StringBuffer sb) {
        sb.append(this.qualifiedName());
    }
}

