/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.model.platformsmodel;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.tools.db.model.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.db.model.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.db.model.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.db.model.platformsmodel.JDBCTypeRepository;
import org.eclipse.persistence.tools.utility.XMLTools;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.io.FileTools;
import org.eclipse.persistence.tools.utility.iterable.LiveCloneIterable;
import org.eclipse.persistence.tools.utility.iterator.IteratorTools;
import org.eclipse.persistence.tools.utility.iterator.TransformationIterator;
import org.eclipse.persistence.tools.utility.node.AbstractNode;
import org.eclipse.persistence.tools.utility.node.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DatabasePlatformRepository
extends AbstractNode {
    private String name;
    public static final String NAME_PROPERTY = "name";
    private File file;
    public static final String FILE_PROPERTY = "file";
    private Collection<DatabasePlatform> platforms;
    public static final String PLATFORMS_COLLECTION = "platforms";
    private DatabasePlatform defaultPlatform;
    public static final String DEFAULT_PLATFORM_PROPERTY = "defaultPlatform";
    private JDBCTypeRepository jdbcTypeRepository;
    private Collection<String> originalPlatformShortFileNames;
    private File originalFile;
    private static final String PLATFORMS_DIRECTORY_NAME = "platforms";
    private static final String DEFAULT_PLATFORM_REPOSITORY_FILE_NAME = "platforms.dpr";
    private static DatabasePlatformRepository defaultRepository;

    public static DatabasePlatformRepository getDefault() {
        if (defaultRepository == null) {
            defaultRepository = DatabasePlatformRepository.buildDefault();
        }
        return defaultRepository;
    }

    private static DatabasePlatformRepository buildDefault() {
        try {
            return new DatabasePlatformRepository(DatabasePlatformRepository.buildDefaultFile());
        }
        catch (CorruptXMLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static File buildDefaultFile() {
        try {
            return FileTools.resourceFile((String)"/platforms.dpr");
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public DatabasePlatformRepository(File file) throws CorruptXMLException {
        super(null);
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.read();
    }

    public DatabasePlatformRepository(String name) {
        super(null);
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.jdbcTypeRepository = new JDBCTypeRepository(this);
        this.originalPlatformShortFileNames = Collections.emptySet();
    }

    protected void initialize() {
        super.initialize();
        this.platforms = new Vector<DatabasePlatform>();
    }

    protected void checkParent(Node parentNode) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, name);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        File old = this.file;
        this.file = file;
        this.firePropertyChanged(FILE_PROPERTY, old, file);
        if (old != null && old.exists()) {
            if (old.getParentFile().equals(file.getParentFile())) {
                if (!old.getName().equals(file.getName())) {
                    this.originalFile = old;
                }
            } else {
                this.markEntireBranchDirty();
                this.originalPlatformShortFileNames = Collections.emptySet();
            }
        }
    }

    public Iterable<DatabasePlatform> platforms() {
        return new LiveCloneIterable<DatabasePlatform>(this.platforms){

            protected void remove(DatabasePlatform current) {
                DatabasePlatformRepository.this.removePlatform(current);
            }
        };
    }

    public int platformsSize() {
        return this.platforms.size();
    }

    public DatabasePlatform addPlatform(String platformName, String platformShortFileName) {
        this.checkPlatform(platformName, platformShortFileName);
        return this.addPlatform(new DatabasePlatform(this, platformName, platformShortFileName));
    }

    private DatabasePlatform addPlatform(DatabasePlatform platform) {
        this.addItemToCollection((Object)platform, this.platforms, "platforms");
        this.markBranchDirty();
        if (this.defaultPlatform == null) {
            this.setDefaultPlatform(platform);
        }
        return platform;
    }

    public void removePlatform(DatabasePlatform platform) {
        this.removeItemFromCollection((Object)platform, this.platforms, "platforms");
        this.markBranchDirty();
        this.resetDefaultPlatform();
    }

    public void removePlatforms(Collection<DatabasePlatform> pforms) {
        this.removeItemsFromCollection(pforms, this.platforms, "platforms");
        this.markBranchDirty();
        this.resetDefaultPlatform();
    }

    public void removePlatforms(Iterator<DatabasePlatform> pforms) {
        this.removeItemsFromCollection(pforms, this.platforms, "platforms");
        this.markBranchDirty();
        this.resetDefaultPlatform();
    }

    public DatabasePlatform getDefaultPlatform() {
        return this.defaultPlatform;
    }

    public void setDefaultPlatform(DatabasePlatform defaultPlatform) {
        if (defaultPlatform == null && this.platforms.size() > 0) {
            throw new NullPointerException();
        }
        DatabasePlatform old = this.defaultPlatform;
        this.defaultPlatform = defaultPlatform;
        this.firePropertyChanged(DEFAULT_PLATFORM_PROPERTY, (Object)old, (Object)defaultPlatform);
    }

    public JDBCTypeRepository getJDBCTypeRepository() {
        return this.jdbcTypeRepository;
    }

    private File platformsDirectory() {
        return new File(this.file.getParentFile(), "platforms");
    }

    public DatabasePlatform platformNamed(String databasePlatformName) {
        Collection<DatabasePlatform> collection = this.platforms;
        synchronized (collection) {
            for (DatabasePlatform platform : this.platforms) {
                if (!platform.getName().equals(databasePlatformName)) continue;
                return platform;
            }
            throw new IllegalArgumentException("missing database platform named: " + databasePlatformName);
        }
    }

    public DatabasePlatform platformForRuntimePlatformClassNamed(String runtimePlatformClassName) {
        Collection<DatabasePlatform> collection = this.platforms;
        synchronized (collection) {
            for (DatabasePlatform platform : this.platforms) {
                if (!platform.getRuntimePlatformClassName().equals(runtimePlatformClassName)) continue;
                return platform;
            }
            throw new IllegalArgumentException("missing database platform for run-time platform class: " + runtimePlatformClassName);
        }
    }

    private Iterator<String> platformNames() {
        return new TransformationIterator<DatabasePlatform, String>(this.platforms()){

            protected String transform(DatabasePlatform next) {
                return next.getName();
            }
        };
    }

    private Iterator<String> platformShortFileNames() {
        return new TransformationIterator<DatabasePlatform, String>(this.platforms()){

            protected String transform(DatabasePlatform next) {
                return next.getShortFileName();
            }
        };
    }

    private Iterator<String> lowerCasePlatformShortFileNames() {
        return new TransformationIterator<String, String>(this.platformShortFileNames()){

            protected String transform(String next) {
                return next.toLowerCase();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List<Node> children) {
        super.addChildrenTo(children);
        Collection<DatabasePlatform> collection = this.platforms;
        synchronized (collection) {
            children.addAll(this.platforms);
        }
        children.add((Node)this.jdbcTypeRepository);
    }

    protected void addTransientAspectNamesTo(Set<String> transientAspectNames) {
        super.addTransientAspectNamesTo(transientAspectNames);
        transientAspectNames.add("platforms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDefaultPlatform() {
        Collection<DatabasePlatform> collection = this.platforms;
        synchronized (collection) {
            if (!this.platforms.contains((Object)this.defaultPlatform)) {
                if (this.platforms.isEmpty()) {
                    this.setDefaultPlatform(null);
                } else {
                    this.setDefaultPlatform(this.platforms.iterator().next());
                }
            }
        }
    }

    public DatabasePlatform clone(DatabasePlatform original) {
        String originalName = original.getName();
        String originalFileName = original.getShortFileName();
        String originalFileNameBase = FileTools.stripExtension((String)originalFileName);
        String originalFileNameExtension = FileTools.extension((String)originalFileName);
        DatabasePlatform clone = null;
        int cloneCount = 1;
        boolean success = false;
        while (!success) {
            String cloneName = String.valueOf(originalName) + ++cloneCount;
            String cloneFileName = String.valueOf(originalFileNameBase) + cloneCount + originalFileNameExtension;
            try {
                clone = this.addPlatform(cloneName, cloneFileName);
                success = true;
            }
            catch (IllegalArgumentException ex) {
                String msg = ex.getMessage();
                if (msg.indexOf(cloneName) != -1 || msg.indexOf(cloneFileName) != -1) continue;
                throw ex;
            }
        }
        clone.cloneFrom(original);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcTypeAdded(JDBCType addedJDBCType) {
        Collection<DatabasePlatform> collection = this.platforms;
        synchronized (collection) {
            for (DatabasePlatform platform : this.platforms) {
                platform.jdbcTypeAdded(addedJDBCType);
            }
        }
    }

    private void checkPlatform(DatabasePlatform platform) {
        this.checkPlatform(platform.getName(), platform.getShortFileName());
    }

    private void checkPlatform(String platformName, String platformShortFileName) {
        this.checkPlatformName(platformName);
        this.checkPlatformShortFileName(platformShortFileName);
    }

    void checkPlatformName(String platformName) {
        if (platformName == null || platformName.length() == 0) {
            throw new IllegalArgumentException("platform name is required");
        }
        if (IteratorTools.contains(this.platformNames(), (Object)platformName)) {
            throw new IllegalArgumentException("duplicate platform name: " + platformName);
        }
    }

    void checkPlatformShortFileName(String platformShortFileName) {
        if (platformShortFileName == null || platformShortFileName.length() == 0) {
            throw new IllegalArgumentException("platform short file name is required");
        }
        if (FileTools.fileNameIsInvalid((String)platformShortFileName)) {
            throw new IllegalArgumentException("invalid file name: " + platformShortFileName);
        }
        if (IteratorTools.contains(this.lowerCasePlatformShortFileNames(), (Object)platformShortFileName.toLowerCase())) {
            throw new IllegalArgumentException("duplicate file name: " + platformShortFileName);
        }
    }

    private void read() throws CorruptXMLException {
        Document document = XMLTools.parse((File)this.file);
        org.w3c.dom.Node root = XMLTools.getChild((org.w3c.dom.Node)document, (String)"platforms");
        if (root == null) {
            throw this.buildCorruptXMLException("missing root node: platforms");
        }
        this.name = XMLTools.getChildTextContent((org.w3c.dom.Node)root, (String)NAME_PROPERTY, null);
        if (this.name == null || this.name.length() == 0) {
            throw this.buildCorruptXMLException("name is required");
        }
        this.jdbcTypeRepository = new JDBCTypeRepository(this, XMLTools.getChild((org.w3c.dom.Node)root, (String)"jdbc-type-repository"));
        this.readPlatforms();
        String defaultPlatformName = XMLTools.getChildTextContent((org.w3c.dom.Node)root, (String)"default-platform", null);
        if (defaultPlatformName == null || defaultPlatformName.length() == 0) {
            if (this.platforms.size() != 0) {
                throw this.buildCorruptXMLException("default platform name is required");
            }
        } else {
            if (this.platforms.size() == 0) {
                throw this.buildCorruptXMLException("default platform should not be specified when there are no platforms");
            }
            try {
                this.defaultPlatform = this.platformNamed(defaultPlatformName);
            }
            catch (IllegalArgumentException ex) {
                throw this.buildCorruptXMLException(ex);
            }
        }
        this.originalPlatformShortFileNames = CollectionTools.collection(this.platformShortFileNames());
        this.markEntireBranchClean();
    }

    private void readPlatforms() throws CorruptXMLException {
        File platformsDirectory = this.platformsDirectory();
        if (platformsDirectory.exists() && platformsDirectory.isDirectory()) {
            File[] platformFiles = platformsDirectory.listFiles();
            int i = platformFiles.length;
            while (i-- > 0) {
                this.readPlatform(platformFiles[i]);
            }
        }
    }

    private void readPlatform(File platformFile) throws CorruptXMLException {
        if (platformFile.isFile() && FileTools.extension((File)platformFile).toLowerCase().equals(".xml")) {
            DatabasePlatform platform = new DatabasePlatform(this, platformFile);
            try {
                this.checkPlatform(platform);
            }
            catch (IllegalArgumentException ex) {
                throw this.buildCorruptXMLException(ex);
            }
            this.platforms.add(platform);
        }
    }

    private CorruptXMLException buildCorruptXMLException(String message) {
        return new CorruptXMLException(String.valueOf(message) + " (" + this.file.getPath() + ")");
    }

    private CorruptXMLException buildCorruptXMLException(Throwable t) {
        return new CorruptXMLException(this.file.getPath(), t);
    }

    public void write() {
        if (this.isCleanBranch()) {
            return;
        }
        if (this.file == null) {
            throw new IllegalStateException("the repository's file must be set before it is written");
        }
        this.writePlatforms();
        if (this.isDirtyBranch()) {
            this.writeRepositoryFile();
            this.markEntireBranchClean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePlatforms() {
        File platformsDirectory = this.platformsDirectory();
        if (platformsDirectory.exists()) {
            if (!platformsDirectory.isDirectory()) {
                throw new IllegalStateException("platforms directory is not a directory: " + platformsDirectory.getAbsolutePath());
            }
        } else if (!platformsDirectory.mkdirs()) {
            throw new RuntimeException("unable to create platforms directory: " + platformsDirectory.getAbsolutePath());
        }
        this.deleteOldPlatformFiles(platformsDirectory);
        Collection<DatabasePlatform> collection = this.platforms;
        synchronized (collection) {
            for (DatabasePlatform platform : this.platforms) {
                platform.write(platformsDirectory);
            }
        }
    }

    private void deleteOldPlatformFiles(File platformsDirectory) {
        HashBag deletedPlatformFileNames = new HashBag(this.originalPlatformShortFileNames);
        HashBag currentPlatformFileNames = CollectionTools.collection(this.platformShortFileNames());
        deletedPlatformFileNames.removeAll((Collection<?>)currentPlatformFileNames);
        for (String fileName : deletedPlatformFileNames) {
            new File(platformsDirectory, fileName).delete();
        }
        this.originalPlatformShortFileNames = currentPlatformFileNames;
    }

    private void writeRepositoryFile() {
        Document document = XMLTools.newDocument();
        Element root = document.createElement("platforms");
        document.appendChild(root);
        XMLTools.addSimpleTextNode((org.w3c.dom.Node)root, (String)NAME_PROPERTY, (String)this.name);
        if (this.defaultPlatform != null) {
            XMLTools.addSimpleTextNode((org.w3c.dom.Node)root, (String)"default-platform", (String)this.defaultPlatform.getName());
        }
        this.jdbcTypeRepository.write(root.appendChild(document.createElement("jdbc-type-repository")));
        XMLTools.print((Document)document, (File)this.file);
        if (this.originalFile != null) {
            if (!this.originalFile.delete()) {
                throw new RuntimeException("unable to delete original file: " + this.originalFile.getPath());
            }
            this.originalFile = null;
        }
    }

    public String displayString() {
        return this.name;
    }

    public void toString(StringBuffer sb) {
        Iterator<DatabasePlatform> stream = this.platforms().iterator();
        while (stream.hasNext()) {
            DatabasePlatform platform = stream.next();
            platform.toString(sb);
            if (!stream.hasNext()) continue;
            sb.append(", ");
        }
    }
}

