/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.model.spi.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.persistence.tools.db.model.spi.ExternalForeignKey;
import org.eclipse.persistence.tools.db.model.spi.ExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.db.model.spi.ExternalTableDescription;
import org.eclipse.persistence.tools.db.model.spi.jdbc.JDBCExternalColumn;
import org.eclipse.persistence.tools.db.model.spi.jdbc.JDBCExternalDatabase;
import org.eclipse.persistence.tools.db.model.spi.jdbc.JDBCExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.db.model.spi.jdbc.JDBCExternalTable;
import org.eclipse.persistence.tools.db.model.spi.jdbc.JDBCExternalTableDescription;
import org.eclipse.persistence.tools.utility.ObjectTools;

final class JDBCExternalForeignKey
implements ExternalForeignKey {
    private final JDBCExternalTable table;
    private final String name;
    private final ExternalTableDescription targetTableDescription;
    private ExternalForeignKeyColumnPair[] columnPairs;

    JDBCExternalForeignKey(JDBCExternalTable table, String name, ResultSet resultSet) {
        this.table = table;
        this.name = name;
        this.targetTableDescription = new JDBCExternalTableDescription(this.stringFrom(resultSet, 1), this.stringFrom(resultSet, 2), this.stringFrom(resultSet, 3), this.database());
    }

    private String stringFrom(ResultSet resultSet, int colIndex) {
        try {
            return this.trim(resultSet.getString(colIndex));
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private String trim(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ExternalForeignKeyColumnPair[] getColumnPairs() {
        return this.columnPairs;
    }

    @Override
    public ExternalTableDescription getTargetTableDescription() {
        return this.targetTableDescription;
    }

    void addColumnPair(ResultSet resultSet) {
        int len = this.columnPairs == null ? 0 : this.columnPairs.length;
        JDBCExternalForeignKeyColumnPair[] temp = new JDBCExternalForeignKeyColumnPair[len + 1];
        if (len != 0) {
            System.arraycopy(this.columnPairs, 0, temp, 0, len);
        }
        temp[len] = new JDBCExternalForeignKeyColumnPair(this, resultSet);
        this.columnPairs = temp;
    }

    JDBCExternalColumn columnNamed(String columnName) {
        return this.table.columnNamed(columnName);
    }

    private JDBCExternalDatabase database() {
        return this.table.database();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (String)this.name);
    }
}

