/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.relational.handles;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.db.relational.ELNode;
import org.eclipse.persistence.tools.utility.iterator.EmptyIterator;
import org.eclipse.persistence.tools.utility.model.listener.ChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.CollectionChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.ListChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.StateChangeListener;
import org.eclipse.persistence.tools.utility.node.Node;
import org.eclipse.persistence.tools.utility.node.Problem;

public abstract class MWHandle
implements ELNode {
    private ELNode parent;
    private NodeReferenceScrubber scrubber;
    private volatile boolean dirty = true;

    protected MWHandle() {
    }

    protected MWHandle(ELNode parent, NodeReferenceScrubber scrubber) {
        this();
        this.setParent(parent);
        this.setScrubberInternal(scrubber);
    }

    public final Node getParent() {
        return this.parent;
    }

    public final void setParent(Node parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.parent = (ELNode)parent;
    }

    public final Iterator<Node> children() {
        return EmptyIterator.instance();
    }

    public final void setChildBackpointers() {
    }

    public final boolean isDescendantOf(Node node) {
        return this == node || this.parent.isDescendantOf(node);
    }

    public final void addBranchReferencesTo(Collection branchReferences) {
        Node node = this.node();
        if (node != null) {
            branchReferences.add(new Node.SimpleReference((Node)this, node));
        }
    }

    public final void addAllNodesTo(Collection nodes) {
        nodes.add(this);
    }

    public final boolean isDirtyBranch() {
        return this.dirty;
    }

    public final void markBranchDirty() {
        throw new IllegalStateException("handles shouldn't have children");
    }

    public final void markEntireBranchDirty() {
        this.markDirty();
    }

    public final void cascadeMarkEntireBranchClean() {
        this.dirty = false;
    }

    public final void markBranchCleanIfPossible() {
        throw new IllegalStateException("handles shouldn't have children");
    }

    private void markDirty() {
        this.dirty = true;
        this.parent.markBranchDirty();
    }

    @Override
    public final ELNode getMWParent() {
        return this.parent;
    }

    protected abstract Node node();

    public void nodeRenamed(Node node) {
        if (this.node() != null && this.node().isDescendantOf(node)) {
            this.markDirty();
        }
    }

    public final void nodeRemoved(Node removedNode) {
        if (this.node() != null && this.node().isDescendantOf(removedNode)) {
            this.scrubber.nodeReferenceRemoved(this.node(), this);
        }
    }

    protected final void setScrubberInternal(NodeReferenceScrubber scrubber) {
        if (scrubber == null) {
            throw new NullPointerException();
        }
        this.scrubber = scrubber;
    }

    public void resolveClassHandles() {
    }

    public void resolveDescriptorHandles() {
    }

    public void resolveMetadataHandles() {
    }

    public void resolveColumnHandles() {
    }

    public void resolveReferenceHandles() {
    }

    public void resolveMethodHandles() {
    }

    public void postProjectBuild() {
        if (this.scrubber == null) {
            throw new NullPointerException("This handle's 'scrubber' should have been set by its parent upon creation.");
        }
    }

    public final String displayString() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" (");
        this.toString(sb);
        sb.append(')');
        return sb.toString();
    }

    public abstract void toString(StringBuffer var1);

    public Node root() {
        return null;
    }

    public Node.Validator getValidator() {
        return null;
    }

    public void setValidator(Node.Validator validator) {
    }

    public void validateBranch() {
    }

    public boolean validateBranchInternal() {
        return false;
    }

    public ListIterator<Problem> branchProblems() {
        return null;
    }

    public int branchProblemsSize() {
        return 0;
    }

    public boolean hasBranchProblems() {
        return false;
    }

    public boolean containsBranchProblem(Problem problem) {
        return false;
    }

    public void rebuildBranchProblems() {
    }

    public void addBranchProblemsTo(List<Problem> branchProblems) {
    }

    public void clearAllBranchProblems() {
    }

    public boolean clearAllBranchProblemsInternal() {
        return false;
    }

    public String comment() {
        return null;
    }

    public void setComment(String comment) {
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    public void addStateChangeListener(StateChangeListener listener) {
    }

    public void removeStateChangeListener(StateChangeListener listener) {
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    }

    public void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
    }

    public void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
    }

    public void addListChangeListener(String listName, ListChangeListener listener) {
    }

    public void removeListChangeListener(String listName, ListChangeListener listener) {
    }

    public static interface NodeReferenceScrubber {
        public static final NodeReferenceScrubber NULL_INSTANCE = new NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
            }

            public String toString() {
                return "NullReferenceScrubber";
            }
        };

        public void nodeReferenceRemoved(Node var1, MWHandle var2);
    }
}

