/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.TemporalType;

/**
 * The external form for a column mapping.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 */
public interface ExternalColumnMapping extends ExternalConvertibleMapping {

	/**
	 * Column definition that represents the column to be used as the version column.
	 */
	ExternalEntityColumn getColumn();

	/**
	 * Returns the data type's name of the field for a NoSQL database.
	 */
	String getNoSqlField();

	/**
	 * Indicates the temporal type of the column.
	 */
	TemporalType getTemporalType();

	/**
	 * Creates new column definition to be used as the version column replacing the old one.
	 */
	void setColumn(String columnName);

	/**
	 * Sets the data type's name of the field for a NoSQL database.
	 */
	void setNoSqlField(String field);

	/**
	 * Sets the temporal type.
	 */
	void setTemporalType(TemporalType type);
}