/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

/**
 * Defines the properties of a Unique Constraint in the ORM.xml. A Unique Constraint defines a group
 * of columns that represent a unique identifier for a table.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 * @see UniqueConstraint
 *
 * @version 2.5
 * @author John Bracken
 */
public interface ExternalUniqueConstraint extends ExternalForm {

	/**
	 * Returns an {@link ListIterator} over all column names listed for this unique constraint.
	 */
	ListIterable<String> columnNames();

	/**
	 * Returns the count of the column names owned by this unique constraint.
	 */
	int columnNamesSize();

	/**
	 * Returns the position of this unique constraints within the list of unique constraints owned
	 * by the parent.
	 */
	int getIndex();

	/**
	 * Updates the list of column names for this unique constraints.
	 */
	void setColumnNames(ListIterator<String> columnNames);
}