/*******************************************************************************
 * Copyright (c) 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlJoinField;
import org.w3c.dom.Element;

/**
 * The external form for {@link org.eclipse.persistence.nosql.annotations.JoinField JoinField}
 *
 * @version 2.5
 * @since 2.5
 * @author Pascal Filion
 */
@SuppressWarnings("nls")
final class NoSqlJoinField extends AbstractExternalForm
                           implements ExternalNoSqlJoinField {

	/**
	 * The position of the join field within the list of the same type.
	 */
	private int index;

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String JOIN_FIELD = "join-field";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	private static final String NAME = "name";

	/**
	 * The attribute name used to store and retrieve the referenced field name property.
	 */
	private static final String REFERENCED_FIELD_NAME = "referenced-field-name";

	/**
	 * Creates a new <code>NoSqlJoinField</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the join field within the list of the same type
	 */
	NoSqlJoinField(AbstractExternalForm parent, int index) {
		super(parent);
		this.index = index;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected final Element addSelf(String elementName, List<String> elementNamesOrder) {
		return addChild(getParent(), elementName, index, elementNamesOrder);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return JOIN_FIELD;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return getAttribute(NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getReferencedFieldName() {
		return getAttribute(REFERENCED_FIELD_NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {
		setAttribute(NAME, name);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setReferencedFieldName(String name) {
		setAttribute(REFERENCED_FIELD_NAME, name);
	}
}