/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

/**
 * The external form of a read transformer.
 *
 * @see TransformationMapping
 *
 * @version 2.5
 * @author Les Davis
 */
@SuppressWarnings("nls")
final class ReadTransformer extends Transformer {

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String READ_TRANSFORMER = "read-transformer";

	/**
	 * Creates a new <code>ReadTransformer</code>.
	 *
	 * @param parent The parent of this external form
	 */
	ReadTransformer(TransformationMapping parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return READ_TRANSFORMER;
	}
}