/*******************************************************************************
 * Copyright (c) 2010, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterator;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

/**
 * Wrap a list iterator on elements of any sub-type of <code>E</code>,
 * converting it into a <em>non-writable</em> list iterator on elements of type
 * <code>E</code>. This shouldn't be a problem since the
 * resulting list iterator disables the methods that would put invalid elements
 * in the iterator's backing list (i.e. {@link #set(Object)} and {@link #add(Object)}).
 *
 * @param <E> the type of elements returned by the iterator
 *
 * @see org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper
 */
public class SuperListIteratorWrapper<E>
	implements ListIterator<E>
{
	private final ListIterator<? extends E> listIterator;


	public SuperListIteratorWrapper(List<? extends E> list) {
		this(list.listIterator());
	}

	public SuperListIteratorWrapper(ListIterable<? extends E> listIterable) {
		this(listIterable.iterator());
	}

	public SuperListIteratorWrapper(ListIterator<? extends E> listIterator) {
		super();
		if (listIterator == null) {
			throw new NullPointerException();
		}
		this.listIterator = listIterator;
	}

	@Override
	public boolean hasNext() {
		return this.listIterator.hasNext();
	}

	@Override
	public E next() {
		return this.listIterator.next();
	}

	@Override
	public int nextIndex() {
		return this.listIterator.nextIndex();
	}

	@Override
	public boolean hasPrevious() {
		return this.listIterator.hasPrevious();
	}

	@Override
	public E previous() {
		return this.listIterator.previous();
	}

	@Override
	public int previousIndex() {
		return this.listIterator.previousIndex();
	}

	@Override
	public void remove() {
		this.listIterator.remove();
	}

	@Override
	public void set(E e) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void add(E e) {
		throw new UnsupportedOperationException();
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this, this.listIterator);
	}
}