/*******************************************************************************
 * Copyright (c) 2010, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.reference;

/**
 * Provide a container for holding an object that cannot be changed.
 * <p>
 * Provisional API: This interface is part of an interim API that is still
 * under development and expected to change significantly before reaching
 * stability. It is available at this early stage to solicit feedback from
 * pioneering adopters on the understanding that any code that uses this API
 * will almost certainly be broken (repeatedly) as the API evolves.
 *
 * @see ModifiableObjectReference
 */
public interface ObjectReference<V> {
	/**
	 * Return the current value.
	 */
	V getValue();

	/**
	 * Return whether the current value is equal to the specified value.
	 */
	boolean valueEquals(Object object);

	/**
	 * Return whether the current value is not equal to the specified value.
	 */
	boolean valueNotEqual(Object object);

	/**
	 * Return whether the current value is <code>null</code>.
	 */
	boolean isNull();

	/**
	 * Return whether the current value is not <code>null</code>.
	 */
	boolean isNotNull();
}