/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.NonCachingComboBoxModel;

public class DefaultListChooser
extends ListChooser {
    private WorkbenchContextHolder contextHolder;
    private DefaultListChooserDialog.Builder builder;

    protected DefaultListChooser(ComboBoxModel model) {
        super(new NonCachingComboBoxModel(model));
    }

    public DefaultListChooser(ComboBoxModel model, WorkbenchContextHolder contextHolder) {
        this(new NonCachingComboBoxModel(model), contextHolder, DefaultListChooserDialog.Builder.DEFAULT_INSTANCE);
    }

    public DefaultListChooser(CachingComboBoxModel model, WorkbenchContextHolder contextHolder, DefaultListChooserDialog.Builder builder) {
        this((ComboBoxModel)model);
        this.initialize(contextHolder);
        this.builder = builder;
    }

    public DefaultListChooser(ComboBoxModel model, WorkbenchContextHolder contextHolder, DefaultListChooserDialog.Builder builder) {
        this(new NonCachingComboBoxModel(model), contextHolder, builder);
    }

    public DefaultListChooser(ComboBoxModel model, WorkbenchContextHolder contextHolder, NodeSelector nodeSelector) {
        this(new NonCachingComboBoxModel(model), contextHolder, nodeSelector, DefaultListChooserDialog.Builder.DEFAULT_INSTANCE);
    }

    public DefaultListChooser(CachingComboBoxModel model, WorkbenchContextHolder contextHolder, NodeSelector nodeSelector, DefaultListChooserDialog.Builder builder) {
        super(model, nodeSelector);
        this.initialize(contextHolder);
        this.builder = builder;
    }

    public DefaultListChooser(ComboBoxModel model, WorkbenchContextHolder contextHolder, NodeSelector nodeSelector, DefaultListChooserDialog.Builder builder) {
        this(new NonCachingComboBoxModel(model), contextHolder, nodeSelector, builder);
    }

    protected void initialize(WorkbenchContextHolder ctxHolder) {
        this.contextHolder = ctxHolder;
        JMenuItem menuItem = new JMenuItem(this.resourceRepository().getString("SELECT_IN_NAVIGATOR_POPUP_MENU_ITEM"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        menuItem.addActionListener(this.buildGoToListener());
        this.getHelpManager().addItemsToPopupMenuForComponent(new JMenuItem[]{menuItem}, this);
    }

    @Override
    protected void browse() {
        DefaultListChooserDialog dialog = this.buildDialog();
        dialog.show();
        if (dialog.wasConfirmed()) {
            this.getModel().setSelectedItem(dialog.selection());
        }
    }

    protected DefaultListChooserDialog buildDialog() {
        if (this.builder.getListCellRenderer() == null) {
            this.builder.setListCellRenderer(this.getRenderer());
        }
        return this.builder.buildDialog(this.getWorkbenchContext(), this.convertToArray(this.getModel()), this.getModel().getSelectedItem());
    }

    protected Object[] convertToArray(ListModel model) {
        int size = model.getSize();
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            result[i] = model.getElementAt(i);
        }
        return result;
    }

    private ActionListener buildGoToListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultListChooser.this.goToSelectedItem();
            }
        };
    }

    protected HelpManager getHelpManager() {
        return this.getApplicationContext().getHelpManager();
    }

    protected ApplicationContext getApplicationContext() {
        return this.getWorkbenchContext().getApplicationContext();
    }

    protected WorkbenchContext getWorkbenchContext() {
        return this.contextHolder.getWorkbenchContext();
    }

    protected ResourceRepository resourceRepository() {
        return this.getApplicationContext().getResourceRepository();
    }
}

