/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.NewClassNameDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UiDescriptorBundle;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

final class RenameDescriptorAction
extends AbstractFrameworkAction {
    RenameDescriptorAction(WorkbenchContext context) {
        super(context.buildExpandedResourceRepositoryContext(UiDescriptorBundle.class));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setIcon(EMPTY_ICON);
        this.initializeTextAndMnemonic("RENAME_DESCRIPTOR_ACTION");
        this.initializeToolTipText("RENAME_DESCRIPTOR_ACTION.toolTipText");
    }

    @Override
    protected void execute(ApplicationNode selectedNode) {
        MWDescriptor descriptor = (MWDescriptor)selectedNode.getValue();
        ApplicationNode projectNode = selectedNode.getProjectRoot();
        this.navigatorSelectionModel().pushExpansionState();
        this.promptToRenameDescriptor(selectedNode);
        this.navigatorSelectionModel().popAndRestoreExpansionState();
        this.navigatorSelectionModel().setSelectedNode(projectNode.descendantNodeForValue((Node)descriptor));
    }

    private void promptToRenameDescriptor(ApplicationNode selectedNode) {
        MWDescriptor descriptor = (MWDescriptor)selectedNode.getValue();
        MWProject project = descriptor.getProject();
        NewClassNameDialog dialog = this.buildNewClassNameDialog(project, selectedNode, descriptor.getName());
        dialog.setTitle(this.resourceRepository().getString("RENAME_CLASS_DIALOG_TITLE"));
        dialog.setAllowExistingType(false);
        dialog.setVisible(true);
        if (dialog.wasCanceled()) {
            return;
        }
        String typeName = dialog.className();
        descriptor.getMWClass().setName(typeName);
        descriptor.setName(typeName);
    }

    private NewClassNameDialog buildNewClassNameDialog(MWProject project, ApplicationNode selectedNode, String typeName) {
        return new NewClassNameDialog(this.buildPackageNames(project), this.buildPackageName(selectedNode), ClassTools.shortNameForClassNamed((String)typeName), project, this.getWorkbenchContext());
    }

    private Collection buildPackageNames(MWProject project) {
        FilteringIterator packageNames = new FilteringIterator(project.packageNames()){

            protected boolean accept(Object packageName) {
                return ((String)packageName).length() > 0;
            }
        };
        return CollectionTools.collection((Iterator)packageNames);
    }

    private String buildPackageName(ApplicationNode selectedNode) {
        return ((MappingsApplicationNode)selectedNode).candidatePackageName();
    }
}

