/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.DescriptorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.CollectionContainerPolicyPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.ContainerPolicyPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.DirectMapContainerPolicyPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public class MappingComponentFactory
extends SwingComponentFactory {
    public static JCheckBox buildReadOnlyCheckBox(ValueModel mappingHolder, ApplicationContext context) {
        JCheckBox checkBox = MappingComponentFactory.buildCheckBox("MAPPING_READ_ONLY_CHECK_BOX", new CheckBoxModelAdapter(MappingComponentFactory.buildReadOnlyHolder(mappingHolder)), context.getResourceRepository());
        context.getHelpManager().addTopicID(checkBox, "mapping.readOnly");
        return checkBox;
    }

    private static PropertyValueModel buildReadOnlyHolder(ValueModel mappingHolder) {
        return new PropertyAspectAdapter(mappingHolder, "readOnly"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWMapping)this.subject).isReadOnly();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWMapping)this.subject).setReadOnly(((Boolean)value).booleanValue());
            }
        };
    }

    public static ListChooser buildReferenceDescriptorChooser(ValueModel referenceMappingHolder, WorkbenchContextHolder contextHolder) {
        DefaultListChooser listChooser = new DefaultListChooser(MappingComponentFactory.buildExtendedReferenceDescriptorComboBoxModel(referenceMappingHolder), contextHolder, MappingComponentFactory.buildDescriptorNodeSelector(contextHolder), MappingComponentFactory.buildReferenceChooserDialogBuilder(contextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository()));
        listChooser.setRenderer(MappingComponentFactory.buildDescriptorListRenderer(contextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository()));
        return listChooser;
    }

    public static NodeSelector buildDescriptorNodeSelector(final WorkbenchContextHolder contextHolder) {
        return new NodeSelector(){

            @Override
            public void selectNodeFor(Object item) {
                ProjectNode projectNode = (ProjectNode)contextHolder.getWorkbenchContext().getNavigatorSelectionModel().getSelectedProjectNodes()[0];
                projectNode.selectDescriptorNodeFor((MWDescriptor)item, contextHolder.getWorkbenchContext().getNavigatorSelectionModel());
            }
        };
    }

    private static ComboBoxModel buildExtendedReferenceDescriptorComboBoxModel(ValueModel referenceMappingHolder) {
        return new ExtendedComboBoxModel(MappingComponentFactory.buildReferenceDescriptorComboBoxModel(referenceMappingHolder));
    }

    private static ComboBoxModel buildReferenceDescriptorComboBoxModel(ValueModel referenceMappingHolder) {
        return new ComboBoxModelAdapter(MappingComponentFactory.buildSortedCandidateReferenceDescriptorsListValue(referenceMappingHolder), MappingComponentFactory.buildReferenceDescriptorValue(referenceMappingHolder));
    }

    private static ListValueModel buildSortedCandidateReferenceDescriptorsListValue(ValueModel referenceMappingHolder) {
        return new SortedListValueModelAdapter(MappingComponentFactory.buildNotifyingCandidateReferenceDescriptorsListValue(referenceMappingHolder), MappingComponentFactory.buildDescriptorComparator());
    }

    private static ListValueModel buildNotifyingCandidateReferenceDescriptorsListValue(ValueModel referenceMappingHolder) {
        return new ItemPropertyListValueModelAdapter(MappingComponentFactory.buildCandidateReferenceDescriptorsCollectionValue(referenceMappingHolder), "name");
    }

    private static CollectionValueModel buildCandidateReferenceDescriptorsCollectionValue(final ValueModel referenceMappingHolder) {
        return new FilteringCollectionValueModel(MappingComponentFactory.buildDescriptorsCollectionValue(referenceMappingHolder)){

            @Override
            protected boolean accept(Object value) {
                MWReferenceObjectMapping referenceMapping = (MWReferenceObjectMapping)referenceMappingHolder.getValue();
                return referenceMapping == null ? false : referenceMapping.descriptorIsValidReferenceDescriptor((MWDescriptor)value);
            }
        };
    }

    private static CollectionValueModel buildDescriptorsCollectionValue(ValueModel referenceMappingHolder) {
        return new CollectionAspectAdapter(MappingComponentFactory.buildProjectValue(referenceMappingHolder), "descriptors"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWProject)this.subject).descriptors();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWProject)this.subject).descriptorsSize();
            }
        };
    }

    private static PropertyValueModel buildProjectValue(ValueModel referenceMappingHolder) {
        return new PropertyAspectAdapter(referenceMappingHolder){

            @Override
            protected Object getValueFromSubject() {
                return ((MWMapping)this.subject).getProject();
            }
        };
    }

    private static PropertyValueModel buildReferenceDescriptorValue(ValueModel referenceMappingHolder) {
        return new PropertyAspectAdapter(referenceMappingHolder, "referenceDescriptor"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWReferenceObjectMapping)this.subject).getReferenceDescriptor();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWReferenceObjectMapping)this.subject).setReferenceDescriptor((MWDescriptor)value);
            }
        };
    }

    private static Comparator buildDescriptorComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((MWDescriptor)o1).displayStringWithPackage().compareTo(((MWDescriptor)o2).displayStringWithPackage());
            }
        };
    }

    private static DefaultListChooserDialog.Builder buildReferenceChooserDialogBuilder(ResourceRepository resourceRepository) {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("REFERENCE_DESCRIPTOR_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("REFERENCE_DESCRIPTOR_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(MappingComponentFactory.buildDescriptorStringConverter(resourceRepository));
        return builder;
    }

    private static ListCellRenderer buildDescriptorListRenderer(ResourceRepository resourceRepository) {
        return new AdaptableListCellRenderer(new DescriptorCellRendererAdapter(resourceRepository));
    }

    private static StringConverter buildDescriptorStringConverter(ResourceRepository resourceRepository) {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWDescriptor)o).displayStringWithPackage();
            }
        };
    }

    public static JCheckBox buildPrivateOwnedCheckBox(ValueModel referenceMappingHolder, ResourceRepository resourceRepository, HelpManager helpManager) {
        JCheckBox checkBox = MappingComponentFactory.buildCheckBox("MAPPING_PRIVATE_OWNED_CHECK_BOX", MappingComponentFactory.buildPrivateOwnedCheckBoxAdapter(referenceMappingHolder), resourceRepository);
        helpManager.addTopicID(checkBox, "mapping.privateOwned");
        return checkBox;
    }

    private static ButtonModel buildPrivateOwnedCheckBoxAdapter(ValueModel referenceMappingHolder) {
        return new CheckBoxModelAdapter(MappingComponentFactory.buildPrivateOwnedHolder(referenceMappingHolder));
    }

    private static PropertyValueModel buildPrivateOwnedHolder(ValueModel referenceMappingHolder) {
        return new PropertyAspectAdapter(referenceMappingHolder, "privateOwned"){

            @Override
            protected Object getValueFromSubject() {
                MWReferenceMapping mapping = (MWReferenceMapping)this.subject;
                return mapping.isPrivateOwned();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                MWReferenceMapping mapping = (MWReferenceMapping)this.subject;
                mapping.setPrivateOwned(((Boolean)value).booleanValue());
            }
        };
    }

    public static JCheckBox buildUsesIndirectionCheckBox(ValueModel indirectableMappingHolder, ResourceRepository resourceRepository, HelpManager helpManager) {
        JCheckBox checkBox = MappingComponentFactory.buildCheckBox("MAPPING_USE_INDIRECTION_CHECK_BOX", MappingComponentFactory.buildUsesIndirectionCheckBoxModel(indirectableMappingHolder), resourceRepository);
        helpManager.addTopicID(checkBox, "mapping.indirection");
        return checkBox;
    }

    private static ButtonModel buildUsesIndirectionCheckBoxModel(ValueModel indirectableMappingHolder) {
        return new CheckBoxModelAdapter(MappingComponentFactory.buildUsesIndirectionValue(indirectableMappingHolder));
    }

    private static PropertyValueModel buildUsesIndirectionValue(ValueModel indirectableMappingHolder) {
        return new PropertyAspectAdapter(indirectableMappingHolder, "indirection"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWIndirectableMapping)this.subject).usesValueHolderIndirection();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                boolean useValueHolderIndirection = (Boolean)value;
                if (useValueHolderIndirection) {
                    ((MWIndirectableMapping)this.subject).setUseValueHolderIndirection();
                } else {
                    ((MWIndirectableMapping)this.subject).setUseNoIndirection();
                }
            }
        };
    }

    public static JCheckBox buildMutableCheckBox(ValueModel transformationMappingHolder, ResourceRepository resourceRepository, HelpManager helpManager) {
        JCheckBox checkBox = MappingComponentFactory.buildCheckBox("TRANSFORMATION_MAPPING_IS_MUTABLE", MappingComponentFactory.buildMutableCheckBoxModel(transformationMappingHolder), resourceRepository);
        helpManager.addTopicID(checkBox, "mapping.transformation.mutable");
        return checkBox;
    }

    private static ButtonModel buildMutableCheckBoxModel(ValueModel transformationMappingHolder) {
        return new CheckBoxModelAdapter(MappingComponentFactory.buildMutableValue(transformationMappingHolder));
    }

    private static PropertyValueModel buildMutableValue(ValueModel transformationMappingHolder) {
        return new PropertyAspectAdapter(transformationMappingHolder, "mutable"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWTransformationMapping)this.subject).isMutable();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWTransformationMapping)this.subject).setMutable(((Boolean)value).booleanValue());
            }
        };
    }

    public static JPanel buildContainerPolicyOptionsBrowser(WorkbenchContextHolder holder, PropertyValueModel subjectHolder, String topicId) {
        ContainerPolicyPanel subPanel = new ContainerPolicyPanel((ValueModel)subjectHolder, holder);
        return MappingComponentFactory.buildContainerOptionsBrowser(holder, subjectHolder, subPanel, topicId);
    }

    public static JPanel buildDirectMapContainerPolicyOptionsBrowser(WorkbenchContextHolder holder, PropertyValueModel subjectHolder, String topicId) {
        DirectMapContainerPolicyPanel subPanel = new DirectMapContainerPolicyPanel(subjectHolder, holder);
        return MappingComponentFactory.buildContainerOptionsBrowser(holder, subjectHolder, subPanel, topicId);
    }

    public static JPanel buildCollectionContainerPolicyOptionsBrowser(WorkbenchContextHolder holder, PropertyValueModel subjectHolder, String topicId) {
        CollectionContainerPolicyPanel subPanel = new CollectionContainerPolicyPanel(subjectHolder, holder);
        return MappingComponentFactory.buildContainerOptionsBrowser(holder, subjectHolder, subPanel, topicId);
    }

    private static JPanel buildContainerOptionsBrowser(WorkbenchContextHolder holder, PropertyValueModel subjectHolder, JPanel subPanel, String topicId) {
        GridBagConstraints constraints = new GridBagConstraints();
        HelpManager help = holder.getWorkbenchContext().getApplicationContext().getHelpManager();
        JPanel container = new JPanel(new GridBagLayout());
        String advancedContainerOptionsTitle = holder.getWorkbenchContext().getApplicationContext().getResourceRepository().getString("COLLECTION_OPTIONS_ADVANCED_BUTTON");
        subPanel.setVisible(false);
        subPanel.setBorder(MappingComponentFactory.buildTitledBorder(holder.getWorkbenchContext().getApplicationContext().getResourceRepository(), "COLLECTION_OPTIONS_ADVANCED_BUTTON"));
        JButton button = MappingComponentFactory.buildButton("COLLECTION_OPTIONS_ADVANCED_BUTTON", holder.getWorkbenchContext().getApplicationContext().getResourceRepository());
        String buttonText = button.getText();
        buttonText = buttonText + " >>";
        button.setText(buttonText);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        help.addTopicID(button, topicId + ".advancedContainerOptions");
        container.add((Component)button, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        help.addTopicID(subPanel, topicId + ".advancedContainerOptions");
        container.add((Component)subPanel, constraints);
        button.addActionListener(MappingComponentFactory.buildAdvancedCollectionOptionsButtonActionListener(button, subPanel, advancedContainerOptionsTitle));
        return container;
    }

    private static ActionListener buildAdvancedCollectionOptionsButtonActionListener(final JButton button, final JPanel selectionPanel, final String title) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (selectionPanel.isVisible()) {
                    selectionPanel.setVisible(false);
                    button.setText(title + " >>");
                } else {
                    selectionPanel.setVisible(true);
                    button.setText("<<");
                }
            }
        };
    }
}

