/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWAbstractAnyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlElementTypeableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.MappingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaComplexTypeChooser;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaValue;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;

public class XmlMappingComponentFactory
extends MappingComponentFactory {
    public static JCheckBox buildWildcardCheckBox(ValueModel mappingHolder, ApplicationContext context) {
        JCheckBox checkBox = XmlMappingComponentFactory.buildCheckBox("WILDCARD_CHECK_BOX", new CheckBoxModelAdapter(XmlMappingComponentFactory.buildWildcardHolder(mappingHolder)), context.getResourceRepository());
        context.getHelpManager().addTopicID(checkBox, "mapping.wildcard");
        return checkBox;
    }

    private static PropertyValueModel buildWildcardHolder(ValueModel mappingHolder) {
        return new PropertyAspectAdapter(mappingHolder, "wildcardMapping"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWAbstractAnyMapping)this.subject).isWildcardMapping();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWAbstractAnyMapping)this.subject).setWildcardMapping(((Boolean)value).booleanValue());
            }
        };
    }

    static JLabel buildElementTypeLabel(ResourceRepository resourceRepository) {
        return XmlMappingComponentFactory.buildLabel("ELEMENT_TYPE_LABEL", resourceRepository);
    }

    static SchemaComplexTypeChooser buildElementTypeChooser(ValueModel xmlMappingHolder, WorkbenchContextHolder contextHolder, JLabel label, String propertyString) {
        return new SchemaComplexTypeChooser(contextHolder, XmlMappingComponentFactory.buildSchemaValue(xmlMappingHolder), XmlMappingComponentFactory.buildElementTypeHolder(xmlMappingHolder, propertyString), label);
    }

    private static SchemaValue buildSchemaValue(final ValueModel xmlMappingHolder) {
        return new SchemaValue(){

            @Override
            public MWXmlSchema schema() {
                return XmlMappingComponentFactory.schemaContextSchema(xmlMappingHolder);
            }
        };
    }

    private static MWXmlSchema schemaContextSchema(ValueModel xmlMappingHolder) {
        return ((MWXmlMapping)xmlMappingHolder.getValue()).schemaContext() == null ? null : ((MWXmlMapping)xmlMappingHolder.getValue()).schemaContext().getSchema();
    }

    private static PropertyValueModel buildElementTypeHolder(ValueModel mappingHolder, String propertyString) {
        return new PropertyAspectAdapter(mappingHolder, propertyString){

            @Override
            protected Object getValueFromSubject() {
                return ((MWXmlElementTypeableMapping)this.subject).getElementType();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWXmlElementTypeableMapping)this.subject).setElementType((MWComplexTypeDefinition)value);
            }
        };
    }
}

