/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWGroupingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AbstractAttributeItemsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;

final class GroupingAttributesPanel
extends AbstractAttributeItemsPanel {
    GroupingAttributesPanel(PropertyValueModel queryHolder, WorkbenchContextHolder contextHolder) {
        super(queryHolder, contextHolder);
    }

    @Override
    String listTitleKey() {
        return "REPORT_QUERY_GROUPING_ATTRIBUTES_LIST";
    }

    @Override
    protected String helpTopicId() {
        return "query.report.groupings";
    }

    @Override
    AddRemovePanel.UpDownOptionAdapter buildAttributesPanelAdapter() {
        return new AddRemovePanel.UpDownOptionAdapter(){

            @Override
            public String optionalButtonKey() {
                return "REPORT_QUERY_GROUPING_ATTRIBUTES_LIST_EDIT_BUTTON";
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                GroupingAttributesPanel.this.editSelectedAttribute((MWAttributeItem)((MWGroupingItem)listSelectionModel.getSelectedValue()));
            }

            @Override
            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                return listSelectionModel.getSelectedValuesSize() == 1;
            }

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                GroupingAttributesPanel.this.addGroupingAttribute();
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] selectedValues = listSelectionModel.getSelectedValues();
                for (int i = 0; i < selectedValues.length; ++i) {
                    ((MWReportQuery)GroupingAttributesPanel.this.getQuery()).removeGroupingItem((MWGroupingItem)selectedValues[i]);
                }
            }

            @Override
            public void moveItemsDown(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    ((MWReportQuery)GroupingAttributesPanel.this.getQuery()).moveGroupingItemDown((MWGroupingItem)items[i]);
                }
            }

            @Override
            public void moveItemsUp(Object[] items) {
                for (int i = 0; i < items.length; ++i) {
                    ((MWReportQuery)GroupingAttributesPanel.this.getQuery()).moveGroupingItemUp((MWGroupingItem)items[i]);
                }
            }
        };
    }

    @Override
    protected ListValueModel buildAttributesHolder() {
        return new ListAspectAdapter(this.getQueryHolder(), "groupingItems"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((MWReportQuery)this.subject).groupingItems();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWReportQuery)this.subject).groupingItemsSize();
            }
        };
    }

    @Override
    protected boolean panelEnabled(MWQueryFormat queryFormat) {
        return queryFormat.groupingAtributesAllowed();
    }

    private void addGroupingAttribute() {
        this.editSelectedAttribute(null);
    }

    @Override
    AttributeItemDialog buildAttributeItemDialog(MWAttributeItem item) {
        AttributeItemDialog dialog = new AttributeItemDialog(this.getQuery(), item, this.getWorkbenchContext()){

            @Override
            protected String titleKey() {
                return "GROUPING_ATTRIBUTES_DIALOG_TITLE";
            }

            @Override
            protected String editTitleKey() {
                return "GROUPING_ATTRIBUTES_EDIT_DIALOG_TITLE";
            }

            @Override
            protected String helpTopicId() {
                return "dialog.groupingAttribute";
            }

            @Override
            protected int attributeItemsSize() {
                return ((MWReportQuery)this.getQuery()).groupingItemsSize();
            }

            @Override
            protected int indexOfAttributeItem(MWAttributeItem attributeItem) {
                return ((MWReportQuery)this.getQuery()).indexOfGroupingItem((MWGroupingItem)attributeItem);
            }

            @Override
            protected void removeAttributeItem(int index) {
                ((MWReportQuery)this.getQuery()).removeGroupingItem(index);
            }

            @Override
            protected void addAttributeItem(int index, Iterator queryables, Iterator allowsNulls) {
                ((MWReportQuery)this.getQuery()).addGroupingItem(index, queryables, allowsNulls);
            }
        };
        return dialog;
    }
}

