/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.ClasspathPanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCClassRepository;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.adapters.PreferencePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.DefaultChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

final class SCPreferencesPage
extends AbstractPanel {
    private CustomizedClassRepository repository;

    SCPreferencesPage(PreferencesContext context) {
        super((LayoutManager)new BorderLayout(), context);
        this.intializeLayout();
        this.addHelpTopicId(this, "preferences.sessions.general");
    }

    private PropertyValueModel buildClasspathHolder() {
        BufferedPropertyValueModel valueModel = new BufferedPropertyValueModel(this.buildClasspathHolderImp(), this.getPreferencesContext().getBufferTrigger());
        valueModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
            }
        });
        return valueModel;
    }

    private PropertyValueModel buildClasspathHolderImp() {
        return new PreferencePropertyValueModel(this.preferences(), "default classpath"){

            @Override
            protected Object getValueFromSubject() {
                String classpath = (String)super.getValueFromSubject();
                if ("".equals(classpath)) {
                    return null;
                }
                return classpath;
            }
        };
    }

    private void intializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel container = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(container);
        scrollPane.getVerticalScrollBar().setBlockIncrement(20);
        scrollPane.setBorder(null);
        scrollPane.setViewportBorder(null);
        this.add((Component)scrollPane, "Center");
        this.repository = new CustomizedClassRepository();
        PropertyValueModel classpathHolder = this.buildClasspathHolder();
        this.repository.update(classpathHolder);
        ClasspathPanel classpathPanel = new ClasspathPanel(this.getApplicationContext(), (ListValueModel)new ClasspathListModel(this.repository, classpathHolder), true, "PREFERENCES_DEFAULT_CLASSPATH_GROUP_BOX");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 5);
        container.add((Component)classpathPanel, constraints);
    }

    private class CustomizedClassRepository
    extends SCClassRepository {
        private CustomizedClassRepository() {
            super(new String[0]);
        }

        public Node.Validator getValidator() {
            return NULL_VALIDATOR;
        }

        public ChangeNotifier getChangeNotifier() {
            return DefaultChangeNotifier.instance();
        }

        public void update(PropertyValueModel classpathHolder) {
            String value = (String)classpathHolder.getValue();
            if (value == null) {
                return;
            }
            Object[] entries = value.split(System.getProperty("path.separator"));
            if (entries.length == 0) {
                return;
            }
            List classpathEntries = CollectionTools.list((Object[])entries);
            CollectionTools.removeAll((Collection)classpathEntries, (Iterator)this.classpathEntries());
            if (!classpathEntries.isEmpty()) {
                this.addClasspathEntries(this.classpathEntriesSize(), classpathEntries);
            }
        }
    }

    private class ClasspathListModel
    extends ListAspectAdapter {
        private final PropertyValueModel preferenceHolder;

        private ClasspathListModel(SCClassRepository repository, PropertyValueModel preferenceHolder) {
            super("classpathEntries", (Model)repository);
            this.preferenceHolder = preferenceHolder;
        }

        @Override
        public void addItem(int index, Object item) {
            SCClassRepository classpath = (SCClassRepository)this.subject;
            classpath.addClasspathEntry(index, (String)item);
            this.preferenceHolder.setValue(classpath.entries());
        }

        @Override
        public Object getItem(int index) {
            SCClassRepository classpath = (SCClassRepository)this.subject;
            return classpath.getClasspathEntry(index);
        }

        @Override
        protected ListIterator getValueFromSubject() {
            SCClassRepository classpath = (SCClassRepository)this.subject;
            return classpath.classpathEntries();
        }

        @Override
        public Object removeItem(int index) {
            SCClassRepository classpath = (SCClassRepository)this.subject;
            String entry = classpath.removeClasspathEntry(index);
            this.preferenceHolder.setValue(classpath.entries());
            return entry;
        }

        @Override
        public Object replaceItem(int index, Object item) {
            SCClassRepository classpath = (SCClassRepository)this.subject;
            String entry = classpath.replaceClasspathEntry(index, (String)item);
            this.preferenceHolder.setValue(classpath.entries());
            return entry;
        }
    }
}

