/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.clustering;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.clustering.RemoteCommandManagerPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.BooleanCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;

public final class SessionClusteringPropertiesPage
extends ScrollablePropertiesPage {
    public SessionClusteringPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    private CollectionValueModel buildClusteringCollectionHolder() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), null){

            @Override
            protected Iterator getValueFromSubject() {
                return new ArrayIterator(new Object[]{Boolean.TRUE, Boolean.FALSE});
            }
        };
    }

    private ComboBoxModel buildClusteringComboBoxAdapter() {
        return new ComboBoxModelAdapter(this.buildClusteringCollectionHolder(), this.buildClusteringTypeSelectionHolder());
    }

    private CellRendererAdapter buildClusteringLabelDecorator() {
        ResourceRepository resourceRepository = this.resourceRepository();
        return new BooleanCellRendererAdapter(resourceRepository.getString("REMOTE_COMMAND"), resourceRepository.getString("DEFAULT_CLUSTERING_TYPE"));
    }

    private SwitcherPanel buildClusteringSwitcherPanel() {
        return new SwitcherPanel(this.buildClusteringTypeHolder(), this.buildClusteringTypeTransformer());
    }

    private PropertyValueModel buildClusteringTypeHolder() {
        String[] propertyNames = new String[]{"remoteCommandManager"};
        return new PropertyAspectAdapter(this.getSelectionHolder(), propertyNames){

            @Override
            protected Object getValueFromSubject() {
                SessionAdapter session = (SessionAdapter)this.subject;
                if (session.hasRemoteCommandManager()) {
                    return session.getRemoteCommandManager();
                }
                return null;
            }
        };
    }

    private PropertyValueModel buildClusteringTypeSelectionHolder() {
        String[] propertyNames = new String[]{"remoteCommandManager"};
        return new PropertyAspectAdapter(this.getSelectionHolder(), propertyNames){

            @Override
            protected Object getValueFromSubject() {
                SessionAdapter adapter = (SessionAdapter)this.subject;
                if (adapter.hasNoClusteringService()) {
                    return Boolean.FALSE;
                }
                return adapter.hasRemoteCommandManager();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                SessionAdapter adapter = (SessionAdapter)this.subject;
                if (Boolean.TRUE.equals(value)) {
                    adapter.setClusteringToRemoteCommandManager();
                } else {
                    adapter.setClusteringToNothing();
                }
            }
        };
    }

    private Transformer buildClusteringTypeTransformer() {
        final Object[] items = new Object[]{new RemoteCommandManagerChoice()};
        return new Transformer(){

            public Object transform(Object value) {
                SessionAdapter session = (SessionAdapter)SessionClusteringPropertiesPage.this.selection();
                if (value == null || session == null) {
                    return null;
                }
                Transformer choice = (Transformer)items[0];
                return choice.transform(value);
            }
        };
    }

    private JPanel buildInternalPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        JComponent clusteringWidgets = this.buildLabeledComboBox("CLUSTERING_CLUSTERING_COMBO_BOX", this.buildClusteringComboBoxAdapter(), new AdaptableListCellRenderer(this.buildClusteringLabelDecorator()));
        clusteringWidgets.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)clusteringWidgets, constraints);
        this.addHelpTopicId(clusteringWidgets, "session.clustering");
        SwitcherPanel clusteringPaneContainer = this.buildClusteringSwitcherPanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)clusteringPaneContainer, constraints);
        return panel;
    }

    @Override
    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        int offset = SwingTools.checkBoxIconWidth();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel internalPane = this.buildInternalPage();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, offset, 0, 0);
        panel.add((Component)internalPane, constraints);
        this.addHelpTopicId(this, "session.clustering");
        return panel;
    }

    private class RemoteCommandManagerChoice
    implements Transformer {
        private RemoteCommandManagerPane pane;

        private RemoteCommandManagerChoice() {
        }

        private PropertyValueModel buildRemoteCommandManagerHolder() {
            return new PropertyAspectAdapter(SessionClusteringPropertiesPage.this.getSelectionHolder(), "remoteCommandManager"){

                @Override
                protected Object getValueFromSubject() {
                    SessionAdapter adapter = (SessionAdapter)this.subject;
                    return adapter.getRemoteCommandManager();
                }
            };
        }

        public Object transform(Object value) {
            if (this.pane == null) {
                this.pane = new RemoteCommandManagerPane((ValueModel)this.buildRemoteCommandManagerHolder(), SessionClusteringPropertiesPage.this.getWorkbenchContextHolder());
                SessionClusteringPropertiesPage.this.addPaneForAlignment(this.pane);
            }
            return this.pane;
        }
    }
}

