/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Arrays;
import java.util.EventObject;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemAspectListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;

public class ItemCollectionListValueModelAdapter
extends ItemAspectListValueModelAdapter {
    protected final String[] collectionNames;
    protected CollectionChangeListener itemCollectionListener;

    public ItemCollectionListValueModelAdapter(ListValueModel listHolder, String collectionName) {
        this(listHolder, new String[]{collectionName});
    }

    public ItemCollectionListValueModelAdapter(ListValueModel listHolder, String collectionName1, String collectionName2) {
        this(listHolder, new String[]{collectionName1, collectionName2});
    }

    public ItemCollectionListValueModelAdapter(ListValueModel listHolder, String collectionName1, String collectionName2, String collectionName3) {
        this(listHolder, new String[]{collectionName1, collectionName2, collectionName3});
    }

    public ItemCollectionListValueModelAdapter(ListValueModel listHolder, String[] collectionNames) {
        super(listHolder);
        this.collectionNames = collectionNames;
    }

    public ItemCollectionListValueModelAdapter(CollectionValueModel collectionHolder, String collectionName) {
        this(collectionHolder, new String[]{collectionName});
    }

    public ItemCollectionListValueModelAdapter(CollectionValueModel collectionHolder, String collectionName1, String collectionName2) {
        this(collectionHolder, new String[]{collectionName1, collectionName2});
    }

    public ItemCollectionListValueModelAdapter(CollectionValueModel collectionHolder, String collectionName1, String collectionName2, String collectionName3) {
        this(collectionHolder, new String[]{collectionName1, collectionName2, collectionName3});
    }

    public ItemCollectionListValueModelAdapter(CollectionValueModel collectionHolder, String[] collectionNames) {
        super(collectionHolder);
        this.collectionNames = collectionNames;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.itemCollectionListener = this.buildItemCollectionListener();
    }

    protected CollectionChangeListener buildItemCollectionListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged((EventObject)e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged((EventObject)e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                ItemCollectionListValueModelAdapter.this.itemAspectChanged((EventObject)e);
            }

            public String toString() {
                return "item collection listener: " + Arrays.asList(ItemCollectionListValueModelAdapter.this.collectionNames);
            }
        };
    }

    @Override
    protected void startListeningToItem(Model item) {
        int i = this.collectionNames.length;
        while (i-- > 0) {
            item.addCollectionChangeListener(this.collectionNames[i], this.itemCollectionListener);
        }
    }

    @Override
    protected void stopListeningToItem(Model item) {
        int i = this.collectionNames.length;
        while (i-- > 0) {
            item.removeCollectionChangeListener(this.collectionNames[i], this.itemCollectionListener);
        }
    }
}

