/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.NullTransformer;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;

public class TransformationValueModel
extends AbstractModel
implements ValueModel {
    private Transformer transformer;
    protected ValueModel valueHolder;
    protected PropertyChangeListener valueChangeListener;

    public TransformationValueModel(ValueModel valueHolder) {
        this(valueHolder, NullTransformer.instance());
    }

    public TransformationValueModel(ValueModel valueHolder, Transformer transformer) {
        this.valueHolder = valueHolder;
        this.transformer = transformer;
    }

    protected void initialize() {
        super.initialize();
        this.valueChangeListener = this.buildValueChangeListener();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected PropertyChangeListener buildValueChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                TransformationValueModel.this.valueChanged(e);
            }

            public String toString() {
                return "value change listener";
            }
        };
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.hasNoPropertyChangeListeners("value")) {
            this.engageValueHolder();
        }
        super.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (propertyName == "value" && this.hasNoPropertyChangeListeners("value")) {
            this.engageValueHolder();
        }
        super.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (this.hasNoPropertyChangeListeners("value")) {
            this.disengageValueHolder();
        }
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.removePropertyChangeListener(propertyName, listener);
        if (propertyName == "value" && this.hasNoPropertyChangeListeners("value")) {
            this.disengageValueHolder();
        }
    }

    protected void engageValueHolder() {
        this.valueHolder.addPropertyChangeListener("value", this.valueChangeListener);
    }

    protected void disengageValueHolder() {
        this.valueHolder.removePropertyChangeListener("value", this.valueChangeListener);
    }

    public void toString(StringBuffer writer) {
        writer.append(this.valueHolder);
    }

    @Override
    public Object getValue() {
        return this.transform(this.valueHolder.getValue());
    }

    protected void valueChanged(PropertyChangeEvent e) {
        Object oldValue = this.transform(e.getOldValue());
        Object newValue = this.transform(e.getNewValue());
        this.firePropertyChanged("value", oldValue, newValue);
    }

    protected Object transform(Object value) {
        return value == null ? null : this.transformNonNull(value);
    }

    protected Object transformNonNull(Object value) {
        return this.transformer.transform(value);
    }
}

