/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.AbstractTreeModel;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class TreeModelAdapter
extends AbstractTreeModel {
    private PropertyValueModel rootHolder;
    private PropertyChangeListener rootListener;
    private StateChangeListener nodeStateListener;
    private PropertyChangeListener nodeValueListener;
    private ListChangeListener childrenListener;
    private TreeNodeValueModel root;
    IdentityHashMap childrenLists;
    IdentityHashMap parents;

    public TreeModelAdapter(PropertyValueModel rootHolder) {
        if (rootHolder == null) {
            throw new NullPointerException();
        }
        this.rootHolder = rootHolder;
    }

    public TreeModelAdapter(TreeNodeValueModel root) {
        this(new ReadOnlyPropertyValueModel(root));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.rootListener = this.buildRootListener();
        this.nodeStateListener = this.buildNodeStateListener();
        this.nodeValueListener = this.buildNodeValueListener();
        this.childrenListener = this.buildChildrenListener();
        this.childrenLists = new IdentityHashMap();
        this.parents = new IdentityHashMap();
    }

    private PropertyChangeListener buildRootListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                TreeModelAdapter.this.rootChanged();
            }

            public String toString() {
                return "root listener";
            }
        };
    }

    private PropertyChangeListener buildNodeValueListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                TreeModelAdapter.this.nodeChanged((TreeNodeValueModel)e.getSource());
            }

            public String toString() {
                return "node value listener";
            }
        };
    }

    private StateChangeListener buildNodeStateListener() {
        return new StateChangeListener(){

            public void stateChanged(StateChangeEvent e) {
                TreeModelAdapter.this.nodeChanged((TreeNodeValueModel)e.getSource());
            }

            public String toString() {
                return "node state listener";
            }
        };
    }

    private ListChangeListener buildChildrenListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                new EventChangePolicy(e).addChildren();
            }

            public void itemsRemoved(ListChangeEvent e) {
                new EventChangePolicy(e).removeChildren();
            }

            public void itemsReplaced(ListChangeEvent e) {
                new EventChangePolicy(e).replaceChildren();
            }

            public void listChanged(ListChangeEvent e) {
                new EventChangePolicy(e).rebuildChildren();
            }

            public String toString() {
                return "children listener";
            }
        };
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((TreeNodeValueModel)parent).getChild(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNodeValueModel)parent).childrenSize();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNodeValueModel)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        ((TreeNodeValueModel)path.getLastPathComponent()).setValue(newValue);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNodeValueModel)parent).indexOfChild((TreeNodeValueModel)child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (this.hasNoTreeModelListeners()) {
            this.engageModel();
        }
        super.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        super.removeTreeModelListener(l);
        if (this.hasNoTreeModelListeners()) {
            this.disengageModel();
        }
    }

    private void engageModel() {
        this.rootHolder.addPropertyChangeListener("value", this.rootListener);
        this.root = (TreeNodeValueModel)this.rootHolder.getValue();
        if (this.root == null) {
            throw new NullPointerException();
        }
        this.engageNode(this.root);
        this.addRoot();
    }

    private void addRoot() {
        this.addNode(0, this.root);
    }

    private void disengageModel() {
        this.removeRoot();
        this.disengageNode(this.root);
        this.root = null;
        this.rootHolder.removePropertyChangeListener("value", this.rootListener);
    }

    private void removeRoot() {
        this.removeNode(0, this.root);
    }

    void rootChanged() {
        TreeNodeValueModel newRoot = (TreeNodeValueModel)this.rootHolder.getValue();
        if (newRoot == null) {
            throw new NullPointerException();
        }
        this.removeRoot();
        TreeNodeValueModel oldRoot = this.root;
        this.root = newRoot;
        this.engageNode(this.root);
        this.fireTreeRootReplaced(this.root);
        this.disengageNode(oldRoot);
        this.addRoot();
    }

    void nodeChanged(TreeNodeValueModel node) {
        TreeNodeValueModel parent = node.getParent();
        if (parent == null) {
            this.fireTreeRootChanged(node);
        } else {
            this.fireTreeNodeChanged(parent.path(), parent.indexOfChild(node), node);
        }
    }

    void addChildren(Object[] path, int[] childIndices, Object[] children) {
        int i;
        int len = childIndices.length;
        for (i = 0; i < len; ++i) {
            this.engageNode((TreeNodeValueModel)children[i]);
        }
        this.fireTreeNodesInserted(path, childIndices, children);
        for (i = 0; i < len; ++i) {
            this.addNode(childIndices[i], (TreeNodeValueModel)children[i]);
        }
    }

    private void engageNode(TreeNodeValueModel node) {
        node.addStateChangeListener(this.nodeStateListener);
        node.addPropertyChangeListener("value", this.nodeValueListener);
        node.getChildrenModel().addListChangeListener("value", this.childrenListener);
    }

    private void addNode(int index, TreeNodeValueModel node) {
        this.addNodeToInternalTree(node.getParent(), index, node, node.getChildrenModel());
        new NodeChangePolicy(node).addChildren();
    }

    private void addNodeToInternalTree(TreeNodeValueModel parent, int index, TreeNodeValueModel node, ListValueModel childrenModel) {
        ArrayList<TreeNodeValueModel> siblings = (ArrayList<TreeNodeValueModel>)this.childrenLists.get(parent);
        if (siblings == null) {
            siblings = new ArrayList<TreeNodeValueModel>();
            this.childrenLists.put(parent, siblings);
        }
        siblings.add(index, node);
        this.parents.put(childrenModel, node);
    }

    void removeChildren(Object[] path, int[] childIndices, Object[] children) {
        int i;
        int len = childIndices.length;
        for (i = 0; i < len; ++i) {
            this.removeNode(childIndices[i] - i, (TreeNodeValueModel)children[i]);
        }
        this.fireTreeNodesRemoved(path, childIndices, children);
        for (i = 0; i < len; ++i) {
            this.disengageNode((TreeNodeValueModel)children[i]);
        }
    }

    private void removeNode(int index, TreeNodeValueModel node) {
        new NodeChangePolicy(node).removeChildren();
        this.removeNodeFromInternalTree(node.getParent(), index, node, node.getChildrenModel());
    }

    private void removeNodeFromInternalTree(TreeNodeValueModel parent, int index, TreeNodeValueModel node, ListValueModel childrenModel) {
        this.parents.remove(childrenModel);
        List siblings = (List)this.childrenLists.get(parent);
        siblings.remove(index);
        if (siblings.isEmpty()) {
            this.childrenLists.remove(parent);
        }
    }

    private void disengageNode(TreeNodeValueModel node) {
        node.getChildrenModel().removeListChangeListener("value", this.childrenListener);
        node.removePropertyChangeListener("value", this.nodeValueListener);
        node.removeStateChangeListener(this.nodeStateListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.root);
    }

    private class NodeChangePolicy
    extends ChangePolicy {
        private TreeNodeValueModel node;

        NodeChangePolicy(TreeNodeValueModel node) {
            this.node = node;
        }

        @Override
        TreeNodeValueModel parent() {
            return this.node;
        }

        @Override
        int childrenStartIndex() {
            return 0;
        }

        @Override
        int childrenSize() {
            return this.node.getChildrenModel().size();
        }

        @Override
        Iterator children() {
            return (Iterator)this.node.getChildrenModel().getValue();
        }
    }

    private class EventChangePolicy
    extends ChangePolicy {
        private ListChangeEvent event;

        EventChangePolicy(ListChangeEvent event) {
            this.event = event;
        }

        @Override
        TreeNodeValueModel parent() {
            return (TreeNodeValueModel)TreeModelAdapter.this.parents.get(this.event.getSource());
        }

        @Override
        int childrenStartIndex() {
            return this.event.getIndex();
        }

        @Override
        int childrenSize() {
            return this.event.size();
        }

        @Override
        Iterator children() {
            return this.event.items();
        }

        void replaceChildren() {
            Object[] path = this.parent().path();
            int[] childIndices = this.childIndices();
            TreeModelAdapter.this.removeChildren(path, childIndices, this.replacedChildren());
            TreeModelAdapter.this.addChildren(path, childIndices, this.childArray());
        }

        void rebuildChildren() {
            TreeNodeValueModel parent = this.parent();
            Object[] path = parent.path();
            List childrenList = (List)TreeModelAdapter.this.childrenLists.get(parent);
            int[] childIndices = this.buildIndices(childrenList.size());
            Object[] childArray = this.buildArray(childrenList.iterator(), childrenList.size());
            TreeModelAdapter.this.removeChildren(path, childIndices, childArray);
            childIndices = this.buildIndices(parent.getChildrenModel().size());
            childArray = this.buildArray((Iterator)parent.getChildrenModel().getValue(), parent.childrenSize());
            TreeModelAdapter.this.addChildren(path, childIndices, childArray);
        }

        Object[] replacedChildren() {
            return this.buildArray(this.event.replacedItems(), this.event.size());
        }
    }

    private abstract class ChangePolicy {
        ChangePolicy() {
        }

        void addChildren() {
            TreeModelAdapter.this.addChildren(this.parent().path(), this.childIndices(), this.childArray());
        }

        void removeChildren() {
            TreeModelAdapter.this.removeChildren(this.parent().path(), this.childIndices(), this.childArray());
        }

        int[] childIndices() {
            return this.buildIndices(this.childrenStartIndex(), this.childrenSize());
        }

        Object[] childArray() {
            return this.buildArray(this.children(), this.childrenSize());
        }

        Object[] buildArray(Iterator stream, int size) {
            Object[] array = new Object[size];
            int i = 0;
            while (stream.hasNext()) {
                array[i] = stream.next();
                ++i;
            }
            return array;
        }

        int[] buildIndices(int size) {
            return this.buildIndices(0, size);
        }

        private int[] buildIndices(int start, int size) {
            int[] indices = new int[size];
            int index = start;
            for (int i = 0; i < size; ++i) {
                indices[i] = index++;
            }
            return indices;
        }

        abstract TreeNodeValueModel parent();

        abstract int childrenStartIndex();

        abstract int childrenSize();

        abstract Iterator children();
    }
}

