/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsio.legacy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.mappingsio.FileNotFoundListener;
import org.eclipse.persistence.tools.workbench.mappingsio.legacy.Project60IOManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.DefaultSPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SPIManager;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

class Project60Reader {
    private Project60IOManager ioManager;
    private File file;
    private Preferences preferences;
    private FileNotFoundListener listener;

    Project60Reader(Project60IOManager ioManager, File file, Preferences preferences, FileNotFoundListener listener) {
        this.ioManager = ioManager;
        this.file = file;
        this.preferences = preferences;
        this.listener = listener;
    }

    MWProject read() {
        return this.readProject();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.file);
    }

    private MWProject readProject() {
        MWProject project;
        try {
            project = (MWProject)this.readObject(this.file);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.injectSPIManager(project, new DefaultSPIManager(this.preferences, project.getName()));
        SubComponentReader[] subComponentReaders = this.buildSubComponentReaders(project);
        for (int i = 0; i < subComponentReaders.length; ++i) {
            subComponentReaders[i].read();
        }
        project.postProjectBuild();
        return project;
    }

    private SubComponentReader[] buildSubComponentReaders(MWProject project) {
        return new SubComponentReader[]{new SubComponentReader(project.getClassRepository()), new SubComponentReader(project.getMetaDataSubComponentContainer()), new SubComponentReader(project.getDescriptorRepository())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object readObject(File xmlFile) throws IOException {
        InputStream stream = null;
        Object object = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(xmlFile));
            object = this.ioManager.getUnmarshaller().unmarshal(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return object;
    }

    File baseDirectory() {
        return this.file.getParentFile();
    }

    String defaultFileNameExtension() {
        return this.ioManager.defaultFileNameExtension();
    }

    String subDirectoryNameFor(Object container) {
        return this.ioManager.subDirectoryNameFor(container);
    }

    void fireFileNotFound(File missingFile) {
        this.ioManager.fireFileNotFound(this.listener, missingFile);
    }

    private void injectSPIManager(MWProject project, SPIManager spiManager) {
        ClassTools.invokeMethod((Object)project, "setSPIManagerForIOManager", SPIManager.class, spiManager);
    }

    private class SubComponentReader {
        private ProjectSubFileComponentContainer container;

        SubComponentReader(ProjectSubFileComponentContainer container) {
            this.container = container;
        }

        void read() {
            String ext = Project60Reader.this.defaultFileNameExtension();
            String subDirectoryName = Project60Reader.this.subDirectoryNameFor(this.container);
            File subDirectory = new File(this.baseDirectory(), subDirectoryName);
            Set names = CollectionTools.set(this.container.originalProjectSubFileComponentNames());
            Vector<MWModel> subComponents = new Vector<MWModel>(names.size());
            Iterator stream = names.iterator();
            while (stream.hasNext()) {
                String name = (String)stream.next();
                String fileName = FileTools.FILE_NAME_ENCODER.encode(name);
                File subFile = new File(subDirectory, fileName + ext);
                MWModel subComponent = (MWModel)this.readObject(subFile);
                if (subComponent == null) {
                    Project60Reader.this.fireFileNotFound(subFile);
                    stream.remove();
                    continue;
                }
                subComponent.setParent((Node)((Object)this.container));
                subComponents.add(subComponent);
            }
            this.container.setProjectSubFileComponents(subComponents);
        }

        private File baseDirectory() {
            return Project60Reader.this.baseDirectory();
        }

        private Object readObject(File xmlFile) {
            try {
                return Project60Reader.this.readObject(xmlFile);
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

