/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorExtractionMethodPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWEisDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWOXDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWDescriptorHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ChainIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TreeIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWDescriptorInheritancePolicy
extends MWAbstractDescriptorPolicy
implements MWInheritancePolicy {
    private volatile boolean isRoot;
    public static final String IS_ROOT_PROPERTY = "isRoot";
    private MWDescriptorHandle parentDescriptorHandle;
    public static final String PARENT_DESCRIPTOR_PROPERTY = "parentDescriptor";
    private volatile MWClassIndicatorPolicy classIndicatorPolicy;
    public static final String CLASS_INDICATOR_POLICY_PROPERTY = "classIndicatorPolicy";

    protected MWDescriptorInheritancePolicy() {
    }

    protected MWDescriptorInheritancePolicy(MWMappingDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.parentDescriptorHandle = new MWDescriptorHandle(this, this.buildParentDescriptorScrubber());
        this.isRoot = false;
        this.classIndicatorPolicy = new MWNullClassIndicatorPolicy(this);
    }

    void initializeParentDescriptor() {
        MWDescriptor descriptor = this.getProject().descriptorForType(this.getOwningDescriptor().getMWClass().getSuperclass());
        if (descriptor != null && descriptor.isActive()) {
            this.setParentDescriptor(descriptor);
        }
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.classIndicatorPolicy);
        children.add(this.parentDescriptorHandle);
    }

    private MWHandle.NodeReferenceScrubber buildParentDescriptorScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWDescriptorInheritancePolicy.this.setParentDescriptor(null);
            }

            public String toString() {
                return "MWDescriptorInheritancePolicy.buildParentDescriptorScrubber()";
            }
        };
    }

    @Override
    public void descriptorInheritanceChanged() {
        Iterator stream = this.childDescriptors();
        while (stream.hasNext()) {
            ((MWDescriptor)stream.next()).inheritanceChanged();
        }
    }

    @Override
    public void parentDescriptorMorphedToAggregate() {
        this.getClassIndicatorPolicy().parentDescriptorMorphedToAggregate();
    }

    @Override
    public MWDescriptor getParentDescriptor() {
        return this.parentDescriptorHandle.getDescriptor();
    }

    public void setParentDescriptor(MWDescriptor newParentDescriptor) {
        if (newParentDescriptor != null && this.isRoot()) {
            throw new IllegalStateException("Unable to set a parent descriptor on a root descriptor");
        }
        MWDescriptor oldParentDescriptor = this.getParentDescriptor();
        if (oldParentDescriptor != newParentDescriptor) {
            MWInheritancePolicy rootInheritancePolicy = null;
            rootInheritancePolicy = this.getRootDescriptor().getInheritancePolicy();
            this.parentDescriptorHandle.setDescriptor(newParentDescriptor);
            rootInheritancePolicy.buildClassIndicatorValues();
            this.firePropertyChanged(PARENT_DESCRIPTOR_PROPERTY, oldParentDescriptor, newParentDescriptor);
            this.getRootDescriptor().getInheritancePolicy().buildClassIndicatorValues();
            this.getOwningDescriptor().inheritanceChanged();
        }
    }

    @Override
    public Iterator candidateParentDescriptors() {
        final Set descendentDescriptors = CollectionTools.set(this.descendentDescriptors());
        final MWMappingDescriptor thisDescriptor = this.getOwningDescriptor();
        return new FilteringIterator(this.getProject().descriptors()){

            @Override
            protected boolean accept(Object o) {
                MWDescriptor descriptor = (MWDescriptor)o;
                return descriptor.canHaveInheritance() && descriptor != thisDescriptor && !descendentDescriptors.contains(o);
            }
        };
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    public void setIsRoot(boolean newValue) {
        MWInheritancePolicy rootInheritancePolicy = this.getRootDescriptor().getInheritancePolicy();
        boolean oldValue = this.isRoot;
        this.isRoot = newValue;
        if (oldValue != newValue) {
            if (this.isRoot) {
                this.setParentDescriptor(null);
                this.useClassIndicatorFieldPolicy();
                this.buildClassIndicatorValues();
            } else {
                this.setClassIndicatorPolicy(new MWNullClassIndicatorPolicy(this));
                this.initializeParentDescriptor();
                rootInheritancePolicy.buildClassIndicatorValues();
                rootInheritancePolicy = this.getRootDescriptor().getInheritancePolicy();
            }
            rootInheritancePolicy.buildClassIndicatorValues();
            this.firePropertyChanged(IS_ROOT_PROPERTY, oldValue, newValue);
        }
    }

    @Override
    public MWClassIndicatorPolicy getClassIndicatorPolicy() {
        return this.classIndicatorPolicy;
    }

    public void useClassExtractionMethodIndicatorPolicy() {
        if (this.getClassIndicatorPolicy().getType() == "classExtractionMethodClassIndicatorPolicy") {
            return;
        }
        this.setClassIndicatorPolicy(new MWClassIndicatorExtractionMethodPolicy(this));
    }

    public void useClassIndicatorFieldPolicy() {
        if (this.getClassIndicatorPolicy().getType() == "fieldClassIndicatorPolicy") {
            return;
        }
        this.setClassIndicatorPolicy(this.buildClassIndicatorFieldPolicy());
    }

    protected abstract MWClassIndicatorFieldPolicy buildClassIndicatorFieldPolicy();

    protected void setClassIndicatorPolicy(MWClassIndicatorPolicy classIndicatorPolicy) {
        MWClassIndicatorPolicy oldValue = this.getClassIndicatorPolicy();
        this.classIndicatorPolicy = classIndicatorPolicy;
        this.firePropertyChanged(CLASS_INDICATOR_POLICY_PROPERTY, oldValue, classIndicatorPolicy);
    }

    public HashSet getAllDescriptorsAvailableForIndicatorDictionary() {
        HashSet<MWMappingDescriptor> result = new HashSet<MWMappingDescriptor>();
        result.add(this.getOwningDescriptor());
        CollectionTools.addAll(result, this.descendentDescriptors());
        return result;
    }

    @Override
    public Iterator descendentDescriptors() {
        return new TreeIterator(this.childDescriptors()){

            @Override
            protected Iterator children(Object next) {
                return ((MWDescriptor)next).getInheritancePolicy().childDescriptors();
            }
        };
    }

    public boolean hasDescendentDescriptors() {
        return this.descendentDescriptors().hasNext();
    }

    @Override
    public Iterator childDescriptors() {
        return new FilteringIterator(this.getProject().mappingDescriptors()){

            @Override
            protected boolean accept(Object o) {
                return ((MWDescriptor)o).getInheritancePolicy().getParentDescriptor() == MWDescriptorInheritancePolicy.this.getOwningDescriptor();
            }
        };
    }

    public boolean hasChildDescriptors() {
        return this.childDescriptors().hasNext();
    }

    @Override
    public Iterator descriptorLineage() {
        return new ChainIterator(this.getOwningDescriptor()){

            @Override
            protected Object nextLink(Object currentLink) {
                return ((MWDescriptor)currentLink).getInheritancePolicy().getParentDescriptor();
            }
        };
    }

    @Override
    public MWDescriptor getRootDescriptor() {
        MWDescriptor rootDescriptor = null;
        Iterator stream = this.descriptorLineage();
        while (stream.hasNext()) {
            rootDescriptor = (MWDescriptor)stream.next();
        }
        return rootDescriptor;
    }

    @Override
    public void descriptorReplaced(MWDescriptor oldDescriptor, MWDescriptor newDescriptor) {
        super.descriptorReplaced(oldDescriptor, newDescriptor);
        if (this.getParentDescriptor() == oldDescriptor) {
            this.setParentDescriptor(newDescriptor);
        }
    }

    public MWTable getReadAllSubclassesView() {
        return null;
    }

    @Override
    public void buildClassIndicatorValues() {
        this.getClassIndicatorPolicy().rebuildClassIndicatorValues(this.getAllDescriptorsAvailableForIndicatorDictionary());
    }

    @Override
    public MWMappingDescriptor getContainingDescriptor() {
        return this.getOwningDescriptor();
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        if (this.isRoot()) {
            this.checkClassIndicatorValues(newProblems);
            this.descriptorTypeInheritanceMismatchTest(newProblems);
        } else {
            this.checkParentDescriptor(newProblems);
        }
        this.checkRootClassIndicatorFieldPolicy(newProblems);
    }

    private void checkClassIndicatorValues(List newProblems) {
        MWClassIndicatorPolicy cip = this.getClassIndicatorPolicy();
        if (cip.getType() != "fieldClassIndicatorPolicy") {
            return;
        }
        MWClassIndicatorFieldPolicy cifp = (MWClassIndicatorFieldPolicy)this.getClassIndicatorPolicy();
        if (cifp.classNameIsIndicator()) {
            return;
        }
        Iterator stream = cifp.includedClassIndicatorValues();
        while (stream.hasNext()) {
            MWClassIndicatorValue value = (MWClassIndicatorValue)stream.next();
            if (value.getDescriptorValue().getMWClass().isAbstract() && value.getIndicatorValue() != null) {
                newProblems.add(this.buildProblem("0013", value.getDescriptorValue().getMWClass().shortName()));
            }
            if (value.getDescriptorValue().isActive()) continue;
            newProblems.add(this.buildProblem("0355", value.getDescriptorValue().getMWClass().shortName()));
        }
        if (cifp.classIndicatorValuesSize() == 0 && this.hasDescendentDescriptors()) {
            newProblems.add(this.buildProblem("0123"));
        }
    }

    private void checkParentDescriptor(List newProblems) {
        if (this.getParentDescriptor() == null) {
            newProblems.add(this.buildProblem("0357"));
        } else {
            if (!this.getParentDescriptor().isActive()) {
                newProblems.add(this.buildProblem("0356"));
            }
            if (!this.getParentDescriptor().getInheritancePolicy().isActive()) {
                newProblems.add(this.buildProblem("0118"));
            }
        }
    }

    private void checkRootClassIndicatorFieldPolicy(List newProblems) {
        if (this.getOwningDescriptor().getMWClass().isAbstract()) {
            return;
        }
        if (this.getParentDescriptor() == null) {
            return;
        }
        MWInheritancePolicy ip = this.getRootDescriptor().getInheritancePolicy();
        if (!ip.isActive()) {
            return;
        }
        MWDescriptorInheritancePolicy dip = (MWDescriptorInheritancePolicy)ip;
        if (dip.getClassIndicatorPolicy().getType() != "fieldClassIndicatorPolicy") {
            return;
        }
        MWClassIndicatorFieldPolicy rootIndicatorPolicy = (MWClassIndicatorFieldPolicy)dip.getClassIndicatorPolicy();
        if (rootIndicatorPolicy.classNameIsIndicator()) {
            return;
        }
        MWClassIndicatorValue value = rootIndicatorPolicy.getClassIndicatorValueForDescriptor(this.getOwningDescriptor());
        if (value == null || value.getIndicatorValue() == null || value.getIndicatorValue().toString().length() == 0) {
            newProblems.add(this.buildProblem("0089"));
        }
    }

    private void descriptorTypeInheritanceMismatchTest(List newProblems) {
        if (this.checkDescendantsForDescriptorTypeMismatch()) {
            newProblems.add(this.buildProblem(this.descendantDescriptorTypeMismatchProblemString()));
        }
    }

    protected abstract boolean checkDescendantsForDescriptorTypeMismatch();

    protected abstract String descendantDescriptorTypeMismatchProblemString();

    @Override
    public void automap() {
    }

    @Override
    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        InheritancePolicy runtimeInheritancePolicy = runtimeDescriptor.getInheritancePolicy();
        if (this.getParentDescriptor() != null) {
            runtimeInheritancePolicy.setParentClassName(this.getParentDescriptor().getMWClass().fullName());
        }
        this.classIndicatorPolicy.adjustRuntimeInheritancePolicy(runtimeInheritancePolicy);
    }

    @Override
    public void toString(StringBuffer sb) {
        if (this.getParentDescriptor() != null) {
            sb.append("Parent = " + this.getParentDescriptor().getMWClass().shortName() + " ");
        } else if (this.getClassIndicatorPolicy() != null) {
            sb.append("Root");
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public MWDescriptorPolicy getPersistedPolicy() {
        return this;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDescriptorInheritancePolicy.class);
        InheritancePolicy ip = descriptor.getInheritancePolicy();
        ip.setClassIndicatorFieldName("@type");
        ip.addClassIndicator(MWRelationalDescriptorInheritancePolicy.class, (Object)"relational");
        ip.addClassIndicator(MWOXDescriptorInheritancePolicy.class, (Object)"o-x");
        ip.addClassIndicator(MWEisDescriptorInheritancePolicy.class, (Object)"eis");
        XMLDirectMapping isRootMapping = (XMLDirectMapping)descriptor.addDirectMapping(IS_ROOT_PROPERTY, "is-root/text()");
        isRootMapping.setNullValue((Object)Boolean.TRUE);
        XMLCompositeObjectMapping parentDescriptorMapping = new XMLCompositeObjectMapping();
        parentDescriptorMapping.setAttributeName("parentDescriptorHandle");
        parentDescriptorMapping.setGetMethodName("getParentDescriptorForTopLink");
        parentDescriptorMapping.setSetMethodName("setParentDescriptorForTopLink");
        parentDescriptorMapping.setReferenceClass(MWDescriptorHandle.class);
        parentDescriptorMapping.setXPath("parent-descriptor-handle");
        descriptor.addMapping((DatabaseMapping)parentDescriptorMapping);
        XMLCompositeObjectMapping classIndicatorPolicyMapping = new XMLCompositeObjectMapping();
        classIndicatorPolicyMapping.setAttributeName(CLASS_INDICATOR_POLICY_PROPERTY);
        classIndicatorPolicyMapping.setGetMethodName("getClassIndicatorPolicyForTopLink");
        classIndicatorPolicyMapping.setSetMethodName("setClassIndicatorPolicyForTopLink");
        classIndicatorPolicyMapping.setReferenceClass(MWAbstractClassIndicatorPolicy.class);
        classIndicatorPolicyMapping.setXPath("class-indicator-policy");
        descriptor.addMapping((DatabaseMapping)classIndicatorPolicyMapping);
        return descriptor;
    }

    private MWDescriptorHandle getParentDescriptorForTopLink() {
        return this.parentDescriptorHandle.getDescriptor() == null ? null : this.parentDescriptorHandle;
    }

    private void setParentDescriptorForTopLink(MWDescriptorHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildParentDescriptorScrubber();
        this.parentDescriptorHandle = handle == null ? new MWDescriptorHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWAbstractClassIndicatorPolicy getClassIndicatorPolicyForTopLink() {
        return this.classIndicatorPolicy.getValueForTopLink() == null ? null : this.classIndicatorPolicy.getValueForTopLink();
    }

    private void setClassIndicatorPolicyForTopLink(MWAbstractClassIndicatorPolicy classIndicatorPolicy) {
        this.classIndicatorPolicy = classIndicatorPolicy == null ? new MWNullClassIndicatorPolicy(this) : classIndicatorPolicy;
    }

    @Override
    public void postProjectBuild() {
        super.postProjectBuild();
        if (this.isRoot()) {
            this.getClassIndicatorPolicy().setDescriptorsAvailableForIndicatorDictionaryForTopLink(this.getAllDescriptorsAvailableForIndicatorDictionary().iterator());
        }
    }
}

