/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class MWHandle
implements MWNode {
    private MWNode parent;
    private NodeReferenceScrubber scrubber;
    private volatile boolean dirty = true;

    protected MWHandle() {
    }

    protected MWHandle(MWNode parent, NodeReferenceScrubber scrubber) {
        this();
        this.setParent(parent);
        this.setScrubberInternal(scrubber);
    }

    @Override
    public final Node getParent() {
        return this.parent;
    }

    @Override
    public final void setParent(Node parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.parent = (MWNode)parent;
    }

    @Override
    public final Iterator children() {
        return NullIterator.instance();
    }

    @Override
    public final void setChildBackpointers() {
    }

    @Override
    public final boolean isDescendantOf(Node node) {
        return this == node || this.parent.isDescendantOf(node);
    }

    @Override
    public final void addBranchReferencesTo(Collection branchReferences) {
        Node node = this.node();
        if (node != null) {
            branchReferences.add(new Node.SimpleReference(this, node));
        }
    }

    @Override
    public final void addAllNodesTo(Collection nodes) {
        nodes.add(this);
    }

    @Override
    public final boolean isDirtyBranch() {
        return this.dirty;
    }

    @Override
    public final void markBranchDirty() {
        throw new IllegalStateException("handles shouldn't have children");
    }

    @Override
    public final void markEntireBranchDirty() {
        this.markDirty();
    }

    @Override
    public final void cascadeMarkEntireBranchClean() {
        this.dirty = false;
    }

    @Override
    public final void markBranchCleanIfPossible() {
        throw new IllegalStateException("handles shouldn't have children");
    }

    private void markDirty() {
        this.dirty = true;
        this.parent.markBranchDirty();
    }

    @Override
    public final ChangeNotifier getChangeNotifier() {
        return this.parent.getChangeNotifier();
    }

    @Override
    public final void setChangeNotifier(ChangeNotifier changeNotifier) {
        throw new UnsupportedOperationException("Only root nodes implement #setChangeNotifier(ChangeNotifier): " + this);
    }

    @Override
    public final Node.Validator getValidator() {
        return this.parent.getValidator();
    }

    @Override
    public final void setValidator(Node.Validator validator) {
        throw new UnsupportedOperationException("Only root nodes implement #setValidator(Node.Validator): " + this);
    }

    @Override
    public final ListIterator branchProblems() {
        return NullListIterator.instance();
    }

    @Override
    public final boolean hasBranchProblems() {
        return false;
    }

    @Override
    public final boolean containsBranchProblem(Problem problem) {
        return false;
    }

    @Override
    public final void validateBranch() {
    }

    @Override
    public final boolean validateBranchInternal() {
        return false;
    }

    @Override
    public final void rebuildBranchProblems() {
    }

    @Override
    public final void addBranchProblemsTo(List branchProblems) {
    }

    @Override
    public final int branchProblemsSize() {
        return 0;
    }

    @Override
    public final void clearAllBranchProblems() {
    }

    @Override
    public final boolean clearAllBranchProblemsInternal() {
        return false;
    }

    @Override
    public final MWNode getMWParent() {
        return this.parent;
    }

    @Override
    public final MWProject getProject() {
        return this.getMWParent().getProject();
    }

    public final MWDatabase getDatabase() {
        return this.getProject().getDatabase();
    }

    @Override
    public final MWClassRepository getRepository() {
        return this.getProject().getClassRepository();
    }

    @Override
    public final MWClass typeNamed(String typeName) {
        return this.getRepository().typeNamedInternal(typeName);
    }

    @Override
    public final MWClass typeFor(Class javaClass) {
        return this.typeNamed(javaClass.getName());
    }

    protected abstract Node node();

    @Override
    public void nodeRenamed(Node node) {
        if (this.node() != null && this.node().isDescendantOf(node)) {
            this.markDirty();
        }
    }

    @Override
    public final void nodeRemoved(Node removedNode) {
        if (this.node() != null && this.node().isDescendantOf(removedNode)) {
            this.scrubber.nodeReferenceRemoved(this.node(), this);
        }
    }

    @Override
    public final void descriptorReplaced(MWDescriptor oldDescriptor, MWDescriptor newDescriptor) {
    }

    @Override
    public final void mappingReplaced(MWMapping oldMapping, MWMapping newMapping) {
    }

    @Override
    public final void descriptorUnmapped(Collection mappings) {
    }

    protected final void setScrubberInternal(NodeReferenceScrubber scrubber) {
        if (scrubber == null) {
            throw new NullPointerException();
        }
        this.scrubber = scrubber;
    }

    @Override
    public void resolveClassHandles() {
    }

    @Override
    public void resolveDescriptorHandles() {
    }

    @Override
    public void resolveMetadataHandles() {
    }

    @Override
    public void resolveColumnHandles() {
    }

    @Override
    public void resolveReferenceHandles() {
    }

    @Override
    public void resolveMethodHandles() {
    }

    @Override
    public void postProjectBuild() {
        if (this.scrubber == null) {
            throw new NullPointerException("This handle's 'scrubber' should have been set by its parent upon creation.");
        }
    }

    @Override
    public final String displayString() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        StringTools.buildSimpleToStringOn(this, sb);
        sb.append(" (");
        this.toString(sb);
        sb.append(')');
        return sb.toString();
    }

    public abstract void toString(StringBuffer var1);

    public static interface NodeReferenceScrubber {
        public static final NodeReferenceScrubber NULL_INSTANCE = new NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
            }

            public String toString() {
                return "NullReferenceScrubber";
            }
        };

        public void nodeReferenceRemoved(Node var1, MWHandle var2);
    }
}

