/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWClassBasedTransformer
extends MWTransformer {
    private MWClassHandle transformerClassHandle;
    public static final String TRANSFORMER_CLASS_PROPERTY = "transformerClass";

    private MWClassBasedTransformer() {
    }

    MWClassBasedTransformer(MWTransformer.Parent parent, MWClass transformerClass) {
        super(parent);
        this.setTransformerClass(transformerClass);
    }

    @Override
    protected void initialize(Node parentNode) {
        super.initialize(parentNode);
        this.transformerClassHandle = new MWClassHandle(this, this.buildTransformerClassScrubber());
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.transformerClassHandle);
    }

    private MWHandle.NodeReferenceScrubber buildTransformerClassScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWClassBasedTransformer.this.setTransformerClass(null);
            }

            public String toString() {
                return "MWClassBasedTransformer.buildTransformerClassScrubber()";
            }
        };
    }

    public MWClass getTransformerClass() {
        return this.transformerClassHandle.getType();
    }

    public void setTransformerClass(MWClass newTransformerClass) {
        MWClass oldTransformerClass = this.getTransformerClass();
        this.transformerClassHandle.setType(newTransformerClass);
        if (this.attributeValueHasChanged(oldTransformerClass, newTransformerClass)) {
            this.firePropertyChanged(TRANSFORMER_CLASS_PROPERTY, oldTransformerClass, newTransformerClass);
            this.firePropertyChanged("transformer", oldTransformerClass, newTransformerClass);
            this.getProject().recalculateAggregatePathsToColumn(this.parentDescriptor());
        }
    }

    @Override
    public String fieldNameForRuntime() {
        return "CLASS_TRANSFORMER " + (this.getTransformerClass() == null ? null : this.getTransformerClass().getName());
    }

    @Override
    public AggregateFieldDescription fullFieldDescription() {
        return this.getDescriptionForTransformer(this.getTransformerClass());
    }

    private AggregateFieldDescription getDescriptionForTransformer(MWClass mwClass) {
        final String classDescription = mwClass == null ? null : mwClass.getName();
        return new AggregateFieldDescription(){

            @Override
            public String getMessageKey() {
                return "AGGREGATE_FIELD_DESCRIPTION_FOR_CLASS_BASED_TRANSFORMER";
            }

            @Override
            public Object[] getMessageArguments() {
                return new Object[]{classDescription};
            }
        };
    }

    @Override
    public boolean fieldIsWritten() {
        return true;
    }

    @Override
    public String transformerDisplayString() {
        MWClass type = this.getTransformerClass();
        return type == null ? null : type.displayStringWithPackage();
    }

    @Override
    public void addAttributeTransformerProblemsForMapping(List newProblems, MWTransformationMapping mapping) {
        if (this.getTransformerClass() == null) {
            newProblems.add(this.buildProblem("0521"));
        } else if (!this.getTransformerClass().mightBeAssignableToAttributeTransformer()) {
            newProblems.add(this.buildProblem("0522", this.getTransformerClass().getName()));
        }
    }

    @Override
    public void addFieldTransformerProblemsForAssociation(List newProblems, MWFieldTransformerAssociation association) {
        if (this.getTransformerClass() == null) {
            newProblems.add(this.buildProblem("0529", association.fieldName()));
        } else if (!this.getTransformerClass().mightBeAssignableToFieldTransformer()) {
            newProblems.add(this.buildProblem("0530", this.getTransformerClass().getName(), association.fieldName()));
        }
    }

    @Override
    public void setRuntimeAttributeTransformer(AbstractTransformationMapping mapping) {
        if (this.getTransformerClass() != null) {
            mapping.setAttributeTransformerClassName(this.getTransformerClass().getName());
        }
    }

    @Override
    public void addRuntimeFieldTransformer(AbstractTransformationMapping mapping, DatabaseField runtimeField) {
        if (this.getTransformerClass() != null) {
            mapping.addFieldTransformerClassName(runtimeField, this.getTransformerClass().getName());
        }
    }

    @Override
    public void toString(StringBuffer sb) {
        this.transformerClassHandle.toString(sb);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWClassBasedTransformer.class);
        descriptor.getInheritancePolicy().setParentClass(MWTransformer.class);
        XMLCompositeObjectMapping transformerClassHandleMapping = new XMLCompositeObjectMapping();
        transformerClassHandleMapping.setAttributeName("transformerClassHandle");
        transformerClassHandleMapping.setGetMethodName("getTransformerClassHandleForTopLink");
        transformerClassHandleMapping.setSetMethodName("setTransformerClassHandleForTopLink");
        transformerClassHandleMapping.setReferenceClass(MWClassHandle.class);
        transformerClassHandleMapping.setXPath("transformer-class-handle");
        descriptor.addMapping((DatabaseMapping)transformerClassHandleMapping);
        return descriptor;
    }

    private MWClassHandle getTransformerClassHandleForTopLink() {
        return this.transformerClassHandle.getType() == null ? null : this.transformerClassHandle;
    }

    private void setTransformerClassHandleForTopLink(MWClassHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildTransformerClassScrubber();
        this.transformerClassHandle = handle == null ? new MWClassHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

