/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWMethodBasedTransformer
extends MWTransformer {
    private MWMethodHandle methodHandle;
    public static final String METHOD_PROPERTY = "method";

    private MWMethodBasedTransformer() {
    }

    public MWMethodBasedTransformer(MWTransformer.Parent parent, MWMethod method) {
        super(parent);
        this.setMethod(method);
    }

    MWMethodBasedTransformer(MWTransformer.Parent parent, MWMethodHandle methodHandle) {
        super(parent);
        this.methodHandle = methodHandle.setScrubber(this.buildMethodScrubber());
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.methodHandle = new MWMethodHandle(this, this.buildMethodScrubber());
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.methodHandle);
    }

    private MWHandle.NodeReferenceScrubber buildMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWMethodBasedTransformer.this.setMethod(null);
            }

            public String toString() {
                return "MWMethodBasedTransformer.buildMethodScrubber()";
            }
        };
    }

    public MWMethod getMethod() {
        return this.methodHandle.getMethod();
    }

    public void setMethod(MWMethod newMethod) {
        MWMethod oldMethod = this.getMethod();
        this.methodHandle.setMethod(newMethod);
        if (this.attributeValueHasChanged(oldMethod, newMethod)) {
            this.firePropertyChanged(METHOD_PROPERTY, oldMethod, newMethod);
            this.firePropertyChanged("transformer", oldMethod, newMethod);
            this.getProject().recalculateAggregatePathsToColumn(this.parentDescriptor());
        }
    }

    @Override
    public String fieldNameForRuntime() {
        return "METHOD_TRANSFORMER " + (this.getMethod() == null ? null : this.getMethod().getName());
    }

    @Override
    public AggregateFieldDescription fullFieldDescription() {
        return this.getDescriptionForMethodSignature(this.getMethod());
    }

    private AggregateFieldDescription getDescriptionForMethodSignature(MWMethod method) {
        final String signature = method == null ? null : method.signature();
        return new AggregateFieldDescription(){

            @Override
            public String getMessageKey() {
                return "AGGREGATE_FIELD_DESCRIPTION_FOR_METHOD_BASED_TRANSFORMER";
            }

            @Override
            public Object[] getMessageArguments() {
                return new Object[]{signature};
            }
        };
    }

    @Override
    public boolean fieldIsWritten() {
        return true;
    }

    @Override
    public String transformerDisplayString() {
        MWMethod method = this.getMethod();
        return method == null ? null : method.shortSignature();
    }

    @Override
    public void addAttributeTransformerProblemsForMapping(List newProblems, MWTransformationMapping mapping) {
        if (this.getMethod() == null) {
            newProblems.add(this.buildProblem("0523"));
        } else {
            if (!this.getMethod().isCandidateAttributeTransformerMethod()) {
                newProblems.add(this.buildProblem("0525", this.getMethod().signature()));
            }
            if (!CollectionTools.contains(mapping.getParentDescriptor().getMWClass().allMethods(), (Object)this.getMethod())) {
                newProblems.add(this.buildProblem("0524", this.getMethod().signature()));
            }
        }
    }

    @Override
    public void addFieldTransformerProblemsForAssociation(List newProblems, MWFieldTransformerAssociation association) {
        if (this.getMethod() == null) {
            newProblems.add(this.buildProblem("0531", association.fieldName()));
        } else {
            if (!this.getMethod().isCandidateFieldTransformerMethod()) {
                newProblems.add(this.buildProblem("0533", this.getMethod().signature(), association.fieldName()));
            }
            if (!CollectionTools.contains(association.getMapping().getParentDescriptor().getMWClass().allMethods(), (Object)this.getMethod())) {
                newProblems.add(this.buildProblem("0532", this.getMethod().signature(), association.fieldName()));
            }
        }
    }

    @Override
    public void setRuntimeAttributeTransformer(AbstractTransformationMapping mapping) {
        if (this.getMethod() != null) {
            mapping.setAttributeTransformation(this.getMethod().getName());
        }
    }

    @Override
    public void addRuntimeFieldTransformer(AbstractTransformationMapping mapping, DatabaseField runtimeField) {
        if (this.getMethod() != null) {
            mapping.addFieldTransformation(runtimeField, this.getMethod().getName());
        }
    }

    @Override
    public void toString(StringBuffer sb) {
        this.getMethod().toString(sb);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWMethodBasedTransformer.class);
        descriptor.getInheritancePolicy().setParentClass(MWTransformer.class);
        XMLCompositeObjectMapping methodHandleMapping = new XMLCompositeObjectMapping();
        methodHandleMapping.setAttributeName("methodHandle");
        methodHandleMapping.setGetMethodName("getMethodHandleForTopLink");
        methodHandleMapping.setSetMethodName("setMethodHandleForTopLink");
        methodHandleMapping.setReferenceClass(MWMethodHandle.class);
        methodHandleMapping.setXPath("method-handle");
        descriptor.addMapping((DatabaseMapping)methodHandleMapping);
        return descriptor;
    }

    private MWMethodHandle getMethodHandleForTopLink() {
        return this.methodHandle.getMethod() == null ? null : this.methodHandle;
    }

    private void setMethodHandleForTopLink(MWMethodHandle methodHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildMethodScrubber();
        this.methodHandle = methodHandle == null ? new MWMethodHandle(this, scrubber) : methodHandle.setScrubber(scrubber);
    }
}

