/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.ObjectStringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public class MappingStringHolder
extends ObjectStringHolder {
    public static final StringConverter DEFAULT_STRING_CONVERTER = new StringConverter(){

        @Override
        public String convertToString(Object o) {
            return ((MWMapping)o).getName().toLowerCase();
        }
    };

    public MappingStringHolder(MWMapping mapping, StringConverter stringConverter) {
        super(mapping, stringConverter);
    }

    public MappingStringHolder(MWMapping mapping) {
        this(mapping, DEFAULT_STRING_CONVERTER);
    }

    public MWMapping getMapping() {
        return (MWMapping)this.object;
    }

    public static MappingStringHolder[] buildHolders(Iterator mappings) {
        return MappingStringHolder.buildHolders(CollectionTools.list(mappings));
    }

    public static MappingStringHolder[] buildHolders(Collection mappings) {
        MWMapping[] mappingArray = mappings.toArray(new MWMapping[mappings.size()]);
        MappingStringHolder[] holders = new MappingStringHolder[mappingArray.length];
        int i = mappingArray.length;
        while (i-- > 0) {
            holders[i] = new MappingStringHolder(mappingArray[i]);
        }
        return holders;
    }
}

