/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.resource;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceSpecification;

public final class FileResourceSpecification
extends ResourceSpecification {
    private static String KEY = "FILE_RESOURCE";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(FileResourceSpecification.class);
        descriptor.getInheritancePolicy().setParentClass(ResourceSpecification.class);
        return descriptor;
    }

    private FileResourceSpecification() {
    }

    public FileResourceSpecification(MWModel parent, String filePath) {
        super(parent, filePath);
    }

    @Override
    public String getSourceKey() {
        return KEY;
    }

    @Override
    protected URL resourceUrl() throws ResourceException {
        if (this.location == null || this.location == "") {
            throw ResourceException.unspecifiedResourceException(null);
        }
        File absoluteFile = this.absoluteFile();
        if (!absoluteFile.exists()) {
            throw ResourceException.nonexistentResourceException(null);
        }
        try {
            return absoluteFile.toURL();
        }
        catch (MalformedURLException mue) {
            throw ResourceException.incorrectlySpecifiedResourceException(mue);
        }
    }

    private File absoluteFile() {
        File file = new File(this.location);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.getProject().getSaveDirectory(), this.location);
    }

    @Override
    protected String getLocationForTopLink2() {
        return this.location.replace('\\', '/');
    }

    @Override
    protected void setLocationForTopLink2(String fileName) {
        this.location = new File(fileName).getPath();
    }
}

