/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.xs.XSObject;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.Content;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroup;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWParticle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.NullParticle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.Wildcard;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class ComplexContent
extends Content {
    private volatile boolean mixedFlag;
    private volatile MWParticle particle;

    protected ComplexContent() {
    }

    ComplexContent(ExplicitComplexTypeDefinition parent, boolean mixed) {
        super(parent);
        this.initialize(mixed);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.particle = new NullParticle(this);
    }

    private void initialize(boolean mixed) {
        this.mixedFlag = mixed;
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.particle);
    }

    @Override
    void addDirectlyOwnedComponentsTo(Collection directlyOwnedComponents) {
        if (this.particle instanceof MWElementDeclaration) {
            directlyOwnedComponents.add(this.particle);
        } else {
            this.particle.addDirectlyOwnedComponentsTo(directlyOwnedComponents);
        }
    }

    @Override
    boolean hasTextContent() {
        return this.mixedFlag;
    }

    @Override
    boolean containsWildcard() {
        if (this.particle instanceof Wildcard) {
            return true;
        }
        if (this.particle instanceof MWModelGroup) {
            return ((MWModelGroup)this.particle).containsWildcard();
        }
        return false;
    }

    @Override
    int compareSchemaOrder(MWElementDeclaration element1, MWElementDeclaration element2) {
        return this.particle.compareSchemaOrder(element1, element2);
    }

    @Override
    public Iterator structuralComponents() {
        return new SingleElementIterator(this.particle);
    }

    @Override
    public Iterator descriptorContextComponents() {
        if (this.particle.isDescriptorContextComponent()) {
            return new SingleElementIterator(this.particle);
        }
        return this.particle.descriptorContextComponents();
    }

    @Override
    public Iterator xpathComponents() {
        if (this.particle instanceof MWElementDeclaration) {
            return new SingleElementIterator(this.particle);
        }
        return this.particle.xpathComponents();
    }

    @Override
    public MWElementDeclaration nestedElement(String namespaceUrl, String elementName) {
        if (this.particle instanceof MWElementDeclaration) {
            MWElementDeclaration element = (MWElementDeclaration)this.particle;
            if (namespaceUrl.equals(element.getNamespaceUrl()) && elementName.equals(element.getName())) {
                return element;
            }
            return null;
        }
        return this.particle.nestedElement(namespaceUrl, elementName);
    }

    @Override
    public int totalElementCount() {
        if (this.particle instanceof MWElementDeclaration) {
            return 1;
        }
        return this.particle.totalElementCount();
    }

    @Override
    protected void reloadInternal(XSObject schemaObject) {
        super.reloadInternal(schemaObject);
        XSParticleDecl particleNode = (XSParticleDecl)((XSComplexTypeDecl)schemaObject).getParticle();
        if (this.particle != null && this.particle.isEquivalentTo(particleNode)) {
            this.particle.reload((XSObject)particleNode);
        } else {
            MWParticle oldParticle = this.particle;
            this.particle = MWParticle.ParticleFactory.newParticle(this, particleNode);
            this.getProject().nodeRemoved(oldParticle);
        }
    }

    @Override
    public void resolveReferences() {
        super.resolveReferences();
        this.particle.resolveReferences();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(ComplexContent.class);
        descriptor.getInheritancePolicy().setParentClass(Content.class);
        descriptor.addDirectMapping("mixedFlag", "mixed-flag/text()");
        XMLCompositeObjectMapping particleMapping = new XMLCompositeObjectMapping();
        particleMapping.setAttributeName("particle");
        particleMapping.setReferenceClass(AbstractSchemaComponent.class);
        particleMapping.setXPath("particle");
        descriptor.addMapping((DatabaseMapping)particleMapping);
        return descriptor;
    }
}

