/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.Serializable;
import org.eclipse.persistence.tools.workbench.utility.Command;

public class SynchronizedBoolean
implements Cloneable,
Serializable {
    private boolean value;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedBoolean(boolean value, Object mutex) {
        this.value = value;
        this.mutex = mutex;
    }

    public SynchronizedBoolean(boolean value) {
        this.value = value;
        this.mutex = this;
    }

    public SynchronizedBoolean(Object mutex) {
        this(false, mutex);
    }

    public SynchronizedBoolean() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getValue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTrue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFalse() {
        Object object = this.mutex;
        synchronized (object) {
            return !this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(boolean value) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.value != value) {
                this.value = value;
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrue() {
        Object object = this.mutex;
        synchronized (object) {
            this.setValue(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFalse() {
        Object object = this.mutex;
        synchronized (object) {
            this.setValue(false);
        }
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIs(boolean x) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.value != x) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilTrue() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFalse() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetTrue() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilFalse();
            this.setValue(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetFalse() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilTrue();
            this.setValue(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIs(boolean x, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            if (timeout == 0L) {
                this.waitUntilValueIs(x);
                return true;
            }
            long stop = System.currentTimeMillis() + timeout;
            long remaining = timeout;
            while (this.value != x && remaining > 0L) {
                this.mutex.wait(remaining);
                remaining = stop - System.currentTimeMillis();
            }
            return this.value == x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilTrue(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIs(true, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilFalse(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIs(false, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetTrue(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilFalse(timeout);
            if (success) {
                this.setValue(true);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetFalse(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilTrue(timeout);
            if (success) {
                this.setValue(false);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                return super.clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof SynchronizedBoolean) {
            return this.getValue() == ((SynchronizedBoolean)o).getValue();
        }
        return false;
    }

    public int hashCode() {
        return this.getValue() ? 1 : 0;
    }

    public String toString() {
        return String.valueOf(this.getValue());
    }
}

