/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.ExceptionHandler;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class CodeAttribute
extends Attribute {
    private short maxStack;
    private short maxLocals;
    private int codeLength;
    private byte[] code;
    private short exceptionHandlerCount;
    private ExceptionHandler[] exceptionHandlers;
    private AttributePool attributePool;

    CodeAttribute(ClassFileDataInputStream stream, short nameIndex, AttributePool pool) throws IOException {
        super(stream, nameIndex, pool);
    }

    @Override
    void initializeInfo(ClassFileDataInputStream stream) throws IOException {
        this.maxStack = stream.readU2();
        this.maxLocals = stream.readU2();
        int len = this.codeLength = stream.readU4();
        this.code = new byte[len];
        stream.read(this.code);
        short cnt = this.exceptionHandlerCount = stream.readU2();
        ExceptionHandler[] handlers = this.exceptionHandlers = new ExceptionHandler[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            handlers[i] = new ExceptionHandler(stream, this.constantPool());
        }
        this.attributePool = new AttributePool(stream, this.classFile());
    }

    @Override
    void displayInfoStringOn(IndentingPrintWriter writer) {
        writer.print("max stack: ");
        writer.println(this.maxStack);
        writer.print("max locals: ");
        writer.println(this.maxLocals);
        writer.print("code: ");
        this.writeHexStringOn(this.code, writer);
        writer.println();
        short count = this.exceptionHandlerCount;
        writer.print("Exception Handlers (count: ");
        writer.print(count);
        writer.println(")");
        writer.indent();
        ExceptionHandler[] handlers = this.exceptionHandlers;
        for (short i = 0; i < count; i = (short)(i + 1)) {
            writer.print(i);
            writer.print(": ");
            handlers[i].displayStringOn(writer);
        }
        writer.undent();
        this.attributePool.displayStringOn(writer);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
        short count = this.exceptionHandlerCount;
        ExceptionHandler[] handlers = this.exceptionHandlers;
        for (short i = 0; i < count; i = (short)(i + 1)) {
            handlers[i].accept(visitor);
        }
        this.attributePool.accept(visitor);
    }

    public short getMaxStack() {
        return this.maxStack;
    }

    public short getMaxLocals() {
        return this.maxLocals;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public byte[] getCode() {
        return this.code;
    }

    public short getExceptionHandlerCount() {
        return this.exceptionHandlerCount;
    }

    public ExceptionHandler getExceptionHandler(short index) {
        return this.exceptionHandlers[index];
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public AttributePool getAttributePool() {
        return this.attributePool;
    }

    @Override
    void toString(StringBuffer sb) {
        sb.append("code length: ");
        sb.append(this.codeLength);
    }
}

