/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.Field;
import org.eclipse.persistence.tools.workbench.utility.classfile.Member;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class FieldPool
implements Member.Pool {
    private ClassFile classFile;
    private short count;
    private Field[] fields;

    FieldPool(ClassFileDataInputStream stream, ClassFile classFile) throws IOException {
        this.classFile = classFile;
        this.initialize(stream);
    }

    private void initialize(ClassFileDataInputStream stream) throws IOException {
        short cnt = this.count = stream.readU2();
        Field[] localFields = this.fields = new Field[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            localFields[i] = new Field(stream, this);
        }
    }

    public String displayString() {
        StringWriter sw = new StringWriter(1000);
        IndentingPrintWriter writer = new IndentingPrintWriter(sw);
        this.displayStringOn(writer);
        return sw.toString();
    }

    public void displayStringOn(IndentingPrintWriter writer) {
        short cnt = this.count;
        Field[] localFields = this.fields;
        writer.print("Field Pool (count: ");
        writer.print(cnt);
        writer.println(')');
        writer.indent();
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            writer.print(i);
            writer.print(": ");
            localFields[i].displayStringOn(writer);
        }
        writer.undent();
    }

    public Field fieldNamed(String fieldName) {
        short cnt = this.count;
        Field[] localFields = this.fields;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            Field field = localFields[i];
            if (!field.name().equals(fieldName)) continue;
            return field;
        }
        throw new IllegalArgumentException(fieldName);
    }

    public Field[] declaredFields() {
        short cnt = this.count;
        Field[] localFields = this.fields;
        ArrayList<Field> declaredFields = new ArrayList<Field>(cnt);
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            Field field = localFields[i];
            if (!field.isDeclaredField()) continue;
            declaredFields.add(field);
        }
        return declaredFields.toArray(new Field[declaredFields.size()]);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        short cnt = this.count;
        Field[] localFields = this.fields;
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            localFields[i].accept(visitor);
        }
    }

    @Override
    public ClassFile getClassFile() {
        return this.classFile;
    }

    public short getCount() {
        return this.count;
    }

    public Field get(short index) {
        return this.fields[index];
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.count + " field(s))";
    }
}

