/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.FilterReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.persistence.tools.workbench.utility.classfile.Member;
import org.eclipse.persistence.tools.workbench.utility.classfile.MethodPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;

public class Method
extends Member {
    private FieldType returnDescriptor;
    private FieldType[] parameterDescriptors;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String STATIC_INITIALIZER_NAME = "<clinit>";
    public static final short ACC_BRIDGE = 64;
    public static final short ACC_VARARGS = 128;
    public static final int VISIBLE_ACCESS_FLAGS_MASK = 3391;

    Method(ClassFileDataInputStream stream, MethodPool pool) throws IOException {
        super(stream, pool);
    }

    @Override
    short visibleAccessFlagsMask() {
        return 3391;
    }

    @Override
    public void printDeclarationOn(PrintWriter writer) {
        if (this.isStaticInitializationMethod()) {
            writer.print("<static initialization>");
            return;
        }
        this.printModifierOn(writer);
        if (this.isConstructor()) {
            writer.print(this.codeConstructorName());
        } else {
            this.getReturnDescriptor().printDeclarationOn(writer);
            writer.print(' ');
            writer.print(this.name());
        }
        writer.print('(');
        int len = this.getParameterDescriptors().length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                writer.write(", ");
            }
            this.getParameterDescriptor(i).printDeclarationOn(writer);
        }
        writer.print(')');
        this.getAttributePool().printThrowsClauseOn(writer);
    }

    public String javaReturnTypeName() {
        return this.getReturnDescriptor().javaName();
    }

    public String[] javaParameterTypeNames() {
        FieldType[] ptds = this.getParameterDescriptors();
        int len = ptds.length;
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] names = new String[len];
        int i = len;
        while (i-- > 0) {
            names[i] = ptds[i].javaName();
        }
        return names;
    }

    public String[] exceptionClassNames() {
        return this.getAttributePool().exceptionClassNames();
    }

    public boolean isConstructor() {
        return this.name().equals(CONSTRUCTOR_NAME);
    }

    public boolean isDeclaredConstructor() {
        if (this.isSynthetic()) {
            return false;
        }
        return this.isConstructor();
    }

    public boolean isDeclaredMethod() {
        if (this.isSynthetic()) {
            return false;
        }
        if (this.isConstructor()) {
            return false;
        }
        return !this.isStaticInitializationMethod();
    }

    public String constructorName() {
        if (!this.isConstructor()) {
            throw new IllegalStateException();
        }
        return this.classFile().className();
    }

    public String codeConstructorName() {
        if (!this.isConstructor()) {
            throw new IllegalStateException();
        }
        if (this.classFile().isNestedClass()) {
            return this.classFile().nestedClassName();
        }
        String fullName = this.classFile().className();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    public boolean isStaticInitializationMethod() {
        return this.name().equals(STATIC_INITIALIZER_NAME);
    }

    public boolean isBridge() {
        return (this.getAccessFlags() & 0x40) != 0;
    }

    public boolean isVarArg() {
        return (this.getAccessFlags() & 0x80) != 0;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.getReturnDescriptor().accept(visitor);
        FieldType[] ptds = this.getParameterDescriptors();
        int len = ptds.length;
        for (int i = 0; i < len; ++i) {
            ptds[i].accept(visitor);
        }
        super.accept(visitor);
    }

    public MethodPool getMethodPool() {
        return (MethodPool)this.getPool();
    }

    public FieldType getReturnDescriptor() {
        if (this.returnDescriptor == null) {
            this.buildDescriptors();
        }
        return this.returnDescriptor;
    }

    public FieldType[] getParameterDescriptors() {
        if (this.parameterDescriptors == null) {
            this.buildDescriptors();
        }
        return this.parameterDescriptors;
    }

    public FieldType getParameterDescriptor(int index) {
        if (this.parameterDescriptors == null) {
            this.buildDescriptors();
        }
        return this.parameterDescriptors[index];
    }

    private void buildDescriptors() {
        StringReader reader = new StringReader(this.descriptor());
        try {
            this.parameterDescriptors = Method.buildParameterDescriptors(reader);
            this.returnDescriptor = FieldType.createFieldType(reader);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static FieldType[] buildParameterDescriptors(Reader reader) throws IOException {
        PeekableReader localReader = new PeekableReader(reader);
        int c = localReader.read();
        if (c != 40) {
            throw new IllegalStateException("open parenthesis expected: " + (char)c);
        }
        ArrayList<FieldType> parms = new ArrayList<FieldType>();
        while (localReader.peek() != 41) {
            parms.add(FieldType.createFieldType(localReader));
        }
        localReader.read();
        return parms.toArray(new FieldType[parms.size()]);
    }

    private static class PeekableReader
    extends FilterReader {
        PeekableReader(Reader reader) {
            super(reader);
        }

        public int peek() throws IOException {
            this.mark(1);
            int peek = this.read();
            this.reset();
            return peek;
        }
    }
}

