/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile.descriptor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;

public class ArrayType
extends FieldType {
    private FieldType componentType;

    ArrayType(Reader reader) throws IOException {
        this.componentType = FieldType.createFieldType(reader);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int arrayDepth() {
        return this.componentType.arrayDepth() + 1;
    }

    @Override
    public String elementTypeName() {
        return this.componentType.elementTypeName();
    }

    @Override
    public String javaName() {
        StringBuffer sb = new StringBuffer();
        this.appendArrayJavaNameTo(sb);
        return sb.toString();
    }

    @Override
    public Class javaClass() throws ClassNotFoundException {
        return Class.forName(this.javaName());
    }

    @Override
    public void appendDeclarationTo(StringBuffer sb) {
        this.componentType.appendDeclarationTo(sb);
        sb.append("[]");
    }

    @Override
    public void printDeclarationOn(PrintWriter writer) {
        this.componentType.printDeclarationOn(writer);
        writer.print("[]");
    }

    @Override
    public String internalName() {
        StringBuffer sb = new StringBuffer();
        this.appendArrayInternalNameTo(sb);
        return sb.toString();
    }

    @Override
    void appendArrayJavaNameTo(StringBuffer sb) {
        sb.append('[');
        this.componentType.appendArrayJavaNameTo(sb);
    }

    @Override
    void appendArrayInternalNameTo(StringBuffer sb) {
        sb.append('[');
        this.componentType.appendArrayInternalNameTo(sb);
    }
}

