/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile.descriptor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.ArrayType;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.BaseType;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.ObjectType;

public abstract class FieldType {
    public static FieldType createFieldType(String fieldDescriptor) {
        try {
            return FieldType.createFieldType(new StringReader(fieldDescriptor));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static FieldType createFieldType(Reader reader) throws IOException {
        int c = reader.read();
        switch (c) {
            case 76: {
                return new ObjectType(reader);
            }
            case 91: {
                return new ArrayType(reader);
            }
        }
        return new BaseType(c);
    }

    public static FieldType createFieldTypeForClassConstant(String internalName) {
        if (internalName.charAt(0) == '[') {
            return FieldType.createFieldType(internalName);
        }
        return new ObjectType(internalName);
    }

    public abstract void accept(Visitor var1);

    public abstract int arrayDepth();

    public abstract String elementTypeName();

    public abstract String javaName();

    public abstract Class javaClass() throws ClassNotFoundException;

    public String declaration() {
        StringBuffer sb = new StringBuffer(200);
        this.appendDeclarationTo(sb);
        return sb.toString();
    }

    public abstract void appendDeclarationTo(StringBuffer var1);

    public abstract void printDeclarationOn(PrintWriter var1);

    public abstract String internalName();

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append(ClassTools.shortClassNameForObject(this));
        sb.append('(');
        this.appendDeclarationTo(sb);
        sb.append(')');
        return sb.toString();
    }

    FieldType() {
    }

    abstract void appendArrayJavaNameTo(StringBuffer var1);

    abstract void appendArrayInternalNameTo(StringBuffer var1);
}

