/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.log;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.ExceptionListener;

public class LoggingExceptionListener
implements ExceptionListener {
    private final Logger logger;
    private final Level level;
    private final String message;

    public LoggingExceptionListener(Logger logger, Level level, String message) {
        this.logger = logger;
        this.level = level;
        this.message = message;
    }

    public LoggingExceptionListener(Logger logger, Level level) {
        this(logger, level, "Unexpected Exception");
    }

    public LoggingExceptionListener(Logger logger) {
        this(logger, Level.SEVERE);
    }

    public LoggingExceptionListener() {
        this(Logger.getLogger(null));
    }

    @Override
    public void exceptionThrown(Thread thread, Throwable exception) {
        LogRecord logRecord = new LogRecord(this.level, this.message);
        logRecord.setParameters(new Object[]{thread == null ? "null" : thread.getName()});
        logRecord.setThrown(exception);
        logRecord.setLoggerName(this.logger.getName());
        logRecord.setResourceBundle(this.logger.getResourceBundle());
        this.logger.log(logRecord);
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this);
    }
}

