/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers;

import java.sql.Time;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.distributedservers.ComplexUpdateTest;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;

public class UpdateChangeObjectWithOptimisticLockTest
extends ComplexUpdateTest {
    public UpdateChangeObjectWithOptimisticLockTest() {
    }

    public UpdateChangeObjectWithOptimisticLockTest(Employee originalObject) {
        super(originalObject);
    }

    @Override
    protected void changeObject() {
        Employee employee = (Employee)this.workingCopy;
        employee.setNormalHours(new Time[2]);
        employee.setStartTime(Helper.timeFromHourMinuteSecond((int)1, (int)1, (int)1));
    }

    @Override
    protected void test() {
        this.changeObject();
        if (!this.getUnitOfWork().getParent().compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.getUnitOfWork().commit();
    }

    @Override
    protected void verify() {
        long writtenVersion;
        DatabaseSession remoteServer = ((DistributedServer)DistributedServersModel.getDistributedServers().get(0)).getDistributedSession();
        Employee remoteEmp = (Employee)remoteServer.executeQuery((DatabaseQuery)this.query);
        long remoteVersion = (Long)remoteServer.getDescriptor(Employee.class).getOptimisticLockingPolicy().getWriteLockValue((Object)remoteEmp, (Object)remoteEmp.getId(), (AbstractSession)remoteServer);
        if (remoteVersion != (writtenVersion = ((Long)this.getUnitOfWork().getParent().getDescriptor(Employee.class).getOptimisticLockingPolicy().getWriteLockValue((Object)((Employee)this.objectToBeWritten), (Object)((Employee)this.objectToBeWritten).getId(), this.getUnitOfWork().getParent())).longValue())) {
            throw new TestErrorException("Failed to copy the version number to the remote system");
        }
    }
}

