/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.optimisticlocking.Cooking;
import org.eclipse.persistence.testing.models.optimisticlocking.Gamer;
import org.eclipse.persistence.testing.models.optimisticlocking.Knitting;
import org.eclipse.persistence.testing.models.optimisticlocking.Skill;
import org.eclipse.persistence.testing.tests.optimisticlocking.SwitchableOptimisticLockingPolicyTest;

public class UpdateNullVariableOneToOneValueTest
extends SwitchableOptimisticLockingPolicyTest {
    protected Gamer original;
    protected Gamer original2;

    public UpdateNullVariableOneToOneValueTest(Class optimisticLockingPolicyClass) {
        super(optimisticLockingPolicyClass);
        this.addClassToModify(Gamer.class);
        this.addClassToModify(Knitting.class);
        this.addClassToModify(Cooking.class);
    }

    @Override
    public void setup() {
        super.setup();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.original = new Gamer();
        this.original.setName("Bob");
        this.original.setSkill(null);
        this.original2 = new Gamer();
        this.original2.setName("Doug");
        uow.registerObject((Object)this.original);
        uow.registerObject((Object)this.original2);
        uow.commit();
    }

    public void test() throws TestException {
        try {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.readObjectAndChangeAttributeValue(new Knitting("Knitting", "Lame"));
            this.readObjectAndChangeAttributeValue(null);
            this.readObjectAndChangeAttributeValue(new Cooking("Pwning", "Awesome"));
            this.readObjectAndChangeAttributeValue(new Knitting("Knitting", "Still Lame"));
            this.readObjectAndChangeAttributeValue(null);
            this.deleteObject(this.original);
            this.deleteObject(this.original2);
        }
        catch (Exception tle) {
            this.tlException = tle;
            this.tlException.printStackTrace();
        }
    }

    public void readObjectAndChangeAttributeValue(Skill newSkill) {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Gamer clone = (Gamer)uow.readObject(Gamer.class, new ExpressionBuilder().get("id").equal(this.original.getId()));
        UpdateNullVariableOneToOneValueTest.assertNotNull((String)"The object returned should be not null", (Object)clone);
        clone.setSkill(newSkill);
        uow.commit();
    }

    @Override
    public void reset() {
        super.reset();
        this.original = null;
        this.original2 = null;
    }
}

