/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache.NamedQueryQueryCacheTest;

public class ReportQueryCacheTest
extends NamedQueryQueryCacheTest {
    public ReportQueryCacheTest() {
        this.setDescription("Ensure report queries can use query caching.");
    }

    @Override
    public ReadQuery getQueryForTest() {
        ReportQuery testQuery = new ReportQuery();
        testQuery.setReferenceClass(Employee.class);
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("firstName").like("B%");
        testQuery.setSelectionCriteria(exp);
        testQuery.cacheQueryResults();
        testQuery.addAttribute("firstName");
        return testQuery;
    }

    @Override
    public void verify() {
        super.verify();
        for (ReportQueryResult result : (Vector)this.results) {
            if (((String)result.get("firstName")).startsWith("B")) continue;
            throw new TestErrorException("Incorrect Report Query result returned from the cache.");
        }
    }
}

