/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ScrollableCursorJoinedAttributeTest
extends TestCase {
    protected List cursoredResults;
    protected Exception caughtException;

    public ScrollableCursorJoinedAttributeTest() {
        this.setDescription("Scrollable Cursor Test incorporating a joined attribute");
    }

    public void test() {
        if (this.getSession().getPlatform().isHANA()) {
            throw new TestWarningException("ScrollableCursor is not supported on this platform");
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.cursoredResults = new Vector();
        ReadAllQuery cursoredQuery = new ReadAllQuery(Employee.class);
        cursoredQuery.useScrollableCursor();
        cursoredQuery.addJoinedAttribute(cursoredQuery.getExpressionBuilder().anyOfAllowingNone("phoneNumbers"));
        cursoredQuery.addOrdering(cursoredQuery.getExpressionBuilder().get("id"));
        try {
            ScrollableCursor cursor = (ScrollableCursor)this.getSession().executeQuery((DatabaseQuery)cursoredQuery);
            while (cursor.hasNext()) {
                Object result = cursor.next();
                this.cursoredResults.add(result);
            }
            cursor.close();
        }
        catch (Exception e) {
            this.caughtException = e;
        }
    }

    public void verify() {
        if (this.caughtException != null) {
            this.throwError("Cursored query should not result in an exception", this.caughtException);
        }
        ScrollableCursorJoinedAttributeTest.assertNotSame((String)"Test data for cursored results should be nonzero", (Object)0, (Object)this.cursoredResults.size());
    }

    public void reset() {
        this.cursoredResults = null;
    }
}

