/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.Collection;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.insurance.Address;

public class ComplexJoinedAttributeQueryTest
extends TestCase {
    private Address queryResult = null;

    public ComplexJoinedAttributeQueryTest() {
        this.setDescription("Complex Joined Attribute Query Test");
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery(Address.class);
        Expression zipCodeExpression = new ExpressionBuilder().get("zipCode").equal((Object)"28150");
        Expression ssnExpression = new ExpressionBuilder().get("policyHolder").get("ssn").equal(1111);
        Expression expression = zipCodeExpression.or(ssnExpression);
        Expression policyExpression = new ExpressionBuilder().get("policyHolder").anyOf("policies").get("policyNumber").equal(200);
        Expression phoneExpression = new ExpressionBuilder().get("policyHolder").anyOf("phones").get("areaCode").equal(123);
        expression = expression.and(policyExpression).and(phoneExpression);
        query.setSelectionCriteria(expression);
        query.addJoinedAttribute(new ExpressionBuilder().get("policyHolder"));
        query.addJoinedAttribute(new ExpressionBuilder().get("policyHolder").anyOf("policies"));
        query.addJoinedAttribute(new ExpressionBuilder().get("policyHolder").anyOf("phones"));
        Collection result = (Collection)this.getSession().executeQuery((DatabaseQuery)query);
        if (result != null && result.size() == 1) {
            this.queryResult = (Address)result.toArray()[0];
        }
    }

    public void verify() {
        if (this.queryResult == null) {
            throw new TestErrorException("Address not found.");
        }
    }
}

