/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.transparentindirection.TestSession;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestCase;

public class IndirectListTestAPI
extends ZTestCase {
    Vector list;
    IndirectList testList;

    public IndirectListTestAPI(String name) {
        super(name);
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.list = this.setUpList();
        Vector temp = new Vector(this.list);
        QueryBasedValueHolder vh = new QueryBasedValueHolder((ReadQuery)new ReadAllQuery(), (AbstractRecord)new DatabaseRecord(), (AbstractSession)new TestSession(temp));
        this.testList = new IndirectList();
        this.testList.setValueHolder((ValueHolderInterface)vh);
    }

    protected Vector setUpList() {
        Vector<String> result = new Vector<String>();
        result.addElement("zero");
        result.addElement("one");
        result.addElement("two");
        result.addElement("three");
        result.addElement("four");
        result.addElement("five");
        result.addElement("six");
        result.addElement("seven");
        result.addElement("eight");
        result.addElement("nine");
        return result;
    }

    @Override
    protected void tearDown() {
        super.tearDown();
    }

    public void testAdd1() {
        String temp = "foo";
        this.list.add(3, temp);
        this.testList.add(3, (Object)temp);
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
    }

    public void testAdd2() {
        String temp = "foo";
        this.list.add(temp);
        this.testList.add((Object)temp);
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
    }

    public void testAddAll1() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("foo");
        temp.addElement("bar");
        this.list.addAll(temp);
        this.testList.addAll(temp);
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.containsAll(temp));
    }

    public void testAddAll2() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("foo");
        temp.addElement("bar");
        this.list.addAll(3, temp);
        this.testList.addAll(3, temp);
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.containsAll(temp));
    }

    public void testAddElement() {
        String temp = "foo";
        this.list.addElement(temp);
        this.testList.addElement((Object)temp);
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
    }

    public void testClear() {
        this.list.clear();
        this.testList.clear();
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((this.testList.size() == 0 ? 1 : 0) != 0);
    }

    public void testContains() {
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains(this.list.elementAt(1)));
    }

    public void testContainsAll() {
        IndirectListTestAPI.assertTrue((boolean)this.testList.containsAll(this.list.subList(1, 5)));
    }

    public void testElementAt() {
        IndirectListTestAPI.assertEquals(this.list.elementAt(1), (Object)this.testList.elementAt(1));
    }

    public void testElements() {
        IndirectListTestAPI.assertEquals(this.list.elements().nextElement(), this.testList.elements().nextElement());
    }

    public void testEquals() {
        IndirectListTestAPI.assertTrue((boolean)this.testList.equals((Object)this.list));
    }

    public void testFirstElement() {
        IndirectListTestAPI.assertEquals(this.list.firstElement(), (Object)this.testList.firstElement());
    }

    public void testGet() {
        IndirectListTestAPI.assertEquals(this.list.get(1), (Object)this.testList.get(1));
    }

    public void testHashCode() {
        IndirectListTestAPI.assertEquals((int)this.list.hashCode(), (int)this.testList.hashCode());
    }

    public void testIndexOf1() {
        String temp = "one";
        IndirectListTestAPI.assertEquals((int)this.list.indexOf(temp), (int)this.testList.indexOf((Object)temp));
    }

    public void testIndexOf2() {
        String temp = "seven";
        IndirectListTestAPI.assertEquals((int)this.list.indexOf(temp, 3), (int)this.testList.indexOf((Object)temp, 3));
    }

    public void testInsertElementAt() {
        String temp = "foo";
        this.list.insertElementAt(temp, 3);
        this.testList.insertElementAt((Object)temp, 3);
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
    }

    public void testIsEmpty() {
        IndirectListTestAPI.assertTrue((!this.testList.isEmpty() ? 1 : 0) != 0);
    }

    public void testIterator() {
        int i = 0;
        Iterator stream = this.testList.iterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        IndirectListTestAPI.assertEquals((int)this.list.size(), (int)i);
    }

    public void testLastElement() {
        IndirectListTestAPI.assertEquals(this.list.lastElement(), (Object)this.testList.lastElement());
    }

    public void testLastIndexOf1() {
        String temp = "one";
        IndirectListTestAPI.assertEquals((int)this.list.lastIndexOf(temp), (int)this.testList.lastIndexOf((Object)temp));
    }

    public void testLastIndexOf2() {
        String temp = "one";
        IndirectListTestAPI.assertEquals((int)this.list.lastIndexOf(temp, 7), (int)this.testList.lastIndexOf((Object)temp, 7));
    }

    public void testListIterator1() {
        int i = 0;
        ListIterator stream = this.testList.listIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        IndirectListTestAPI.assertEquals((int)this.list.size(), (int)i);
    }

    public void testListIterator2() {
        int i = 0;
        ListIterator stream = this.testList.listIterator(2);
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        IndirectListTestAPI.assertEquals((int)this.list.size(), (int)(i + 2));
    }

    public void testRemove1() {
        Object temp = this.list.remove(1);
        IndirectListTestAPI.assertEquals(temp, (Object)this.testList.remove(1));
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.contains(temp) ? 1 : 0) != 0);
    }

    public void testRemove2() {
        String temp = "one";
        IndirectListTestAPI.assertTrue((boolean)this.list.remove(temp));
        IndirectListTestAPI.assertTrue((boolean)this.testList.remove((Object)temp));
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
    }

    public void testRemoveAll() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        IndirectListTestAPI.assertTrue((boolean)this.list.removeAll(temp));
        IndirectListTestAPI.assertTrue((boolean)this.testList.removeAll(temp));
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.containsAll(temp) ? 1 : 0) != 0);
    }

    public void testRemoveAllElements() {
        this.list.removeAllElements();
        this.testList.removeAllElements();
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((this.testList.size() == 0 ? 1 : 0) != 0);
    }

    public void testRemoveElement() {
        String temp = "one";
        IndirectListTestAPI.assertTrue((boolean)this.list.removeElement(temp));
        IndirectListTestAPI.assertTrue((boolean)this.testList.removeElement((Object)temp));
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.contains((Object)temp) ? 1 : 0) != 0);
    }

    public void testRemoveElementAt() {
        Object temp = this.testList.elementAt(1);
        this.list.removeElementAt(1);
        this.testList.removeElementAt(1);
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((!this.testList.contains(temp) ? 1 : 0) != 0);
    }

    public void testRetainAll() {
        Vector<String> temp = new Vector<String>();
        temp.addElement("one");
        temp.addElement("two");
        IndirectListTestAPI.assertTrue((boolean)this.list.retainAll(temp));
        IndirectListTestAPI.assertTrue((boolean)this.testList.retainAll(temp));
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.containsAll(temp));
        IndirectListTestAPI.assertEquals((int)temp.size(), (int)this.testList.size());
    }

    public void testSet() {
        String temp = "foo";
        this.list.set(3, temp);
        this.testList.set(3, (Object)temp);
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
    }

    public void testSetElementAt() {
        String temp = "foo";
        this.list.setElementAt(temp, 3);
        this.testList.setElementAt((Object)temp, 3);
        IndirectListTestAPI.assertEquals((Object)this.list, (Object)this.testList);
        IndirectListTestAPI.assertTrue((boolean)this.testList.contains((Object)temp));
    }

    public void testSize() {
        IndirectListTestAPI.assertEquals((int)this.list.size(), (int)this.testList.size());
    }

    public void testSubList() {
        IndirectListTestAPI.assertEquals(this.list.subList(2, 5), (Object)this.testList.subList(2, 5));
    }

    public void testToArray1() {
        Object[] temp = this.list.toArray();
        Vector<Object> v1 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = this.testList.toArray();
        Vector<Object> v2 = new Vector<Object>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        IndirectListTestAPI.assertEquals(v1, v2);
    }

    public void testToArray2() {
        String[] temp = this.list.toArray(new String[0]);
        Vector<String> v1 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v1.addElement(temp[i]);
        }
        temp = (String[])this.testList.toArray((Object[])new String[0]);
        Vector<String> v2 = new Vector<String>(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            v2.addElement(temp[i]);
        }
        IndirectListTestAPI.assertEquals(v1, v2);
    }
}

