/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class UOWHasOnlyDeletesTest
extends AutoVerifyTestCase {
    private boolean hasChanges;

    public UOWHasOnlyDeletesTest() {
        this.setDescription("This test verifies that hasChange() should return true if there have been no other changes than deleting objects");
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employee = (Employee)uow.readObject(Employee.class);
        uow.deleteObject((Object)employee);
        this.hasChanges = uow.hasChanges();
    }

    public void verify() {
        if (!this.hasChanges) {
            throw new TestErrorException("Testcase has failed. UOW hasChange doesn't work correctly.  Does not detect deleted objects.");
        }
    }
}

