/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class UnitOfWorkRevertAndResumeWithNewTest
extends AutoVerifyTestCase {
    public BigDecimal addressId;

    protected void setup() {
        this.addressId = ((Address)this.getSession().readObject(Address.class)).getId();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getAbstractSession().beginTransaction();
    }

    protected void test() {
        if (this.getSession().isDistributedSession()) {
            throw new TestWarningException("Test unavailable on Remote UnitOfWork");
        }
        if (this.getSession().getPlatform().isPostgreSQL()) {
            this.throwWarning("Postgres aborts transaction after error.");
        }
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Vector results = uow.readAllObjects(Employee.class);
        Address address = new Address();
        address.setId(this.addressId);
        address.setStreet("Wallace");
        address.setCity("Wallace");
        address = (Address)uow.registerObject((Object)address);
        Employee emp = (Employee)results.firstElement();
        emp.setAddress(address);
        try {
            uow.commitAndResume();
        }
        catch (Exception e) {
            uow.revertAndResume();
        }
        results = uow.readAllObjects(Employee.class);
        address = new Address();
        address.setStreet("Wallace2");
        address.setCity("Wallace2");
        address = (Address)uow.registerObject((Object)address);
        emp = (Employee)results.firstElement();
        emp.setAddress(address);
        uow.commitAndResume();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

