/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import java.io.File;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventListener;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class EventListenerCollectionTest
extends TestCase {
    protected Project project = null;
    public static final String FILENAME = "EventListenersCollectionShouldBeNonSynchronizedTest.xml";

    public EventListenerCollectionTest() {
        this.setDescription("Ensure event listeners collection is a NonSynchronizedVector.");
    }

    public void setup() {
        this.project = new EmployeeProject();
        ClassDescriptor descriptor = (ClassDescriptor)this.project.getDescriptors().get(Employee.class);
        descriptor.getEventManager().addListener((DescriptorEventListener)new DescriptorEventAdapter());
    }

    public void test() {
        XMLProjectWriter.write((String)FILENAME, (Project)this.project);
        this.project = XMLProjectReader.read((String)FILENAME, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    public void verify() {
        ClassDescriptor descriptor = (ClassDescriptor)this.project.getDescriptors().get(Employee.class);
        Vector listeners = descriptor.getEventManager().getEventListeners();
        if (!(listeners instanceof NonSynchronizedVector)) {
            this.throwError("Descriptor from project XML with event listeners does not use NonSynchronizedVector for event listeners collection.");
        }
    }

    public void reset() {
        File file = new File(FILENAME);
        file.delete();
    }
}

