/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import java.util.List;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class ProjectXMLOrderByQueryKeysTest
extends TestCase {
    private List m_queryKeyExpressionsAfterWrite;
    private List m_queryKeyExpressionsBeforeWrite;
    private static final String TEMP_FILE = "TempTestProjectSafeToDelete.xml";
    private static final String ATTRIBUTE_NAME = "phoneNumbers";

    public ProjectXMLOrderByQueryKeysTest() {
        this.setDescription("Tests the order by query keys on a collection mapping.");
    }

    public void test() {
        EmployeeProject project = new EmployeeProject();
        CollectionMapping mapping = (CollectionMapping)project.getDescriptor(Employee.class).getMappingForAttributeName(ATTRIBUTE_NAME);
        mapping.addAscendingOrdering("ascending1");
        mapping.addDescendingOrdering("descending1");
        mapping.addAscendingOrdering("ascending2");
        mapping.addDescendingOrdering("descending2");
        this.m_queryKeyExpressionsBeforeWrite = mapping.getOrderByQueryKeyExpressions();
        XMLProjectWriter.write((String)TEMP_FILE, (Project)project);
        project = XMLProjectReader.read((String)TEMP_FILE, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        mapping = (CollectionMapping)project.getDescriptor(Employee.class).getMappingForAttributeName(ATTRIBUTE_NAME);
        this.m_queryKeyExpressionsAfterWrite = mapping.getOrderByQueryKeyExpressions();
    }

    protected void verify() {
        if (this.m_queryKeyExpressionsBeforeWrite.size() != this.m_queryKeyExpressionsAfterWrite.size()) {
            throw new TestErrorException("The number of query keys read was not equal to the number written.");
        }
        for (int i = 0; i < this.m_queryKeyExpressionsBeforeWrite.size(); ++i) {
            String key2;
            String key1 = ((FunctionExpression)this.m_queryKeyExpressionsBeforeWrite.get(i)).getBaseExpression().getName();
            if (key1.equals(key2 = ((FunctionExpression)this.m_queryKeyExpressionsAfterWrite.get(i)).getBaseExpression().getName())) continue;
            throw new TestErrorException("Ordering query keys not written (or read) in the same order as they were set.");
        }
    }
}

