/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.metadata.FileBasedProjectCache;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;

public class MetadataCachingTestSuite
extends JUnitTestCase {
    String fileName = "MetadataCachingTestProject.file";

    public MetadataCachingTestSuite() {
    }

    public MetadataCachingTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("MetadataCachingTestSuite");
        suite.addTest((Test)new MetadataCachingTestSuite("testProjectCacheALLWithDefaultPU"));
        return suite;
    }

    public Map getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.ddl-generation", "none");
        properties.put("eclipselink.deploy-on-startup", "true");
        properties.put("eclipselink.project-cache", "java-serialization");
        properties.put("eclipselink.project-cache.java-serialization.file-location", this.fileName);
        return properties;
    }

    public void testSetup() {
        boolean exists = false;
        File file = new File(this.fileName);
        boolean bl = file.exists() ? !file.delete() : (exists = false);
        if (exists) {
            MetadataCachingTestSuite.fail((String)("the file exists and could not be removed.  file: " + this.fileName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileBasedProjectCacheWriting(String persistenceUnitName) {
        EntityManager em = MetadataCachingTestSuite.createEntityManager((String)persistenceUnitName);
        Map properties = this.getProperties();
        this.beginTransaction(em);
        try {
            JpaHelper.getEntityManagerFactory((EntityManager)em).refreshMetadata(properties);
        }
        finally {
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        File file = new File(this.fileName);
        if (!file.exists()) {
            MetadataCachingTestSuite.fail((String)"the project cache file was not created on deployment using PROJECT_CACHE 'java-serialization'");
        }
    }

    public void testFileBasedProjectCacheReading(String persistenceUnitName) {
        FileBasedProjectCache projectCache = new FileBasedProjectCache();
        ServerSession session = MetadataCachingTestSuite.getServerSession((String)persistenceUnitName);
        Project project = projectCache.retrieveProject(this.getProperties(), session.getDatasourcePlatform().getConversionManager().getLoader(), session.getSessionLog());
        if (project == null) {
            MetadataCachingTestSuite.fail((String)"Project returned from FileBasedProjectCache.retrieveProject() was null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileBasedProjectCacheLoading(String persistenceUnitName) {
        EntityManager em = MetadataCachingTestSuite.createEntityManager((String)persistenceUnitName);
        this.beginTransaction(em);
        try {
            JpaHelper.getEntityManagerFactory((EntityManager)em).refreshMetadata(this.getProperties());
        }
        finally {
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testProjectCacheALLWithDefaultPU() {
        this.testSetup();
        this.testFileBasedProjectCacheWriting("default");
        this.testFileBasedProjectCacheReading("default");
        this.testFileBasedProjectCacheLoading("default");
    }

    public void testProjectCacheWithDefaultPU() {
        this.testFileBasedProjectCacheLoading("default");
    }
}

