/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.models.jpa.performance.Employee;
import org.eclipse.persistence.testing.models.jpa.performance.EmployeeService;
import org.eclipse.persistence.testing.tests.jpa.performance.concurrent.JPAClusteredEJBConcurrencyComparisonTest;

public class JPAClusteredConcurrencyComparisonModel
extends TestModel {
    public void addTests() {
        this.addTest((Test)this.buildClusterValidationTest());
        this.addTest((Test)this.buildComputeLagTest());
    }

    public void setup() {
        JPAClusteredEJBConcurrencyComparisonTest test = new JPAClusteredEJBConcurrencyComparisonTest();
        test.getEmployeeService().createTables();
        test.getEmployeeService().populate();
        test.nextEmployeeService();
        test.nextEmployeeService();
        test.nextEmployeeService();
    }

    public TestCase buildClusterValidationTest() {
        TestCase test = new TestCase(){

            public void test() {
                int index;
                JPAClusteredEJBConcurrencyComparisonTest test = new JPAClusteredEJBConcurrencyComparisonTest();
                EmployeeService service = test.nextEmployeeService();
                Employee employee = (Employee)service.findAll().get(0);
                for (index = 0; index < 5; ++index) {
                    service = test.nextEmployeeService();
                    employee = service.findById(employee.getId());
                }
                for (index = 0; index < 5; ++index) {
                    service = test.nextEmployeeService();
                    int random = (int)(Math.random() * 1000000.0);
                    employee = service.findById(employee.getId());
                    employee.setLastName(String.valueOf(random));
                    service.update(employee);
                    try {
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
            }
        };
        test.setName("ClusterValidationTest");
        return test;
    }

    public TestCase buildComputeLagTest() {
        TestCase test = new TestCase(){

            public void test() {
                JPAClusteredEJBConcurrencyComparisonTest test = new JPAClusteredEJBConcurrencyComparisonTest();
                EmployeeService service = test.nextEmployeeService();
                Employee employee = (Employee)service.findAll().get(0);
                for (int index = 0; index < 5; ++index) {
                    service = test.nextEmployeeService();
                    employee = service.findById(employee.getId());
                }
                int[] sleeps = new int[]{1, 50, 100, 500, 1000, 2000, 3000, 4000, 5000, 10000};
                int sleep = 0;
                boolean success = false;
                boolean failed = false;
                while (!success && sleep < sleeps.length) {
                    for (int index = 0; index < 10; ++index) {
                        service = test.nextEmployeeService();
                        int random = (int)(Math.random() * 1000000.0);
                        employee = service.findById(employee.getId());
                        employee.setLastName(String.valueOf(random));
                        try {
                            service.update(employee);
                        }
                        catch (Exception lockError) {
                            System.out.println("Failed at sleep of:" + sleeps[sleep] + " on attmept:" + index);
                            ++sleep;
                            failed = true;
                            break;
                        }
                        try {
                            Thread.sleep(sleeps[sleep]);
                            continue;
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    if (!failed) {
                        success = true;
                        System.out.println("Success at sleep of:" + sleeps[sleep]);
                        break;
                    }
                    failed = false;
                }
            }
        };
        test.setName("ComputeLagTest");
        return test;
    }
}

