/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.inheritance;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.Boat;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.Bus;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.Company;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.InheritanceModelExamples;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.MacBook;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.MacBookPro;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.Person;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.SportsCar;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.listeners.BusListener;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.listeners.BusListener2;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.listeners.BusListener3;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.listeners.BusNativeListener;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.listeners.DefaultListener;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.listeners.DefaultListener1;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.listeners.DefaultListener2;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.listeners.DefaultListener3;
import org.eclipse.persistence.testing.tests.jpa.TestingProperties;

public class EntityMappingsInheritanceJUnitTestCase
extends JUnitTestCase {
    private static Number busId;
    private static Number boatId;
    private static Number sportsCarId;
    private String m_persistenceUnit;

    public EntityMappingsInheritanceJUnitTestCase() {
    }

    public EntityMappingsInheritanceJUnitTestCase(String name) {
        super(name);
    }

    public EntityMappingsInheritanceJUnitTestCase(String name, String persistenceUnit) {
        super(name);
        this.m_persistenceUnit = persistenceUnit;
    }

    public static Test suite() {
        String ormTesting = TestingProperties.getProperty("orm.testing", "jpa");
        String persistenceUnit = ormTesting.equals("jpa") ? "default" : "extended-inheritance";
        TestSuite suite = new TestSuite("Inheritance Model - " + persistenceUnit);
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testSetup", persistenceUnit));
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testCreateFueledVehicle", persistenceUnit));
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testCreateBusFueledVehicle", persistenceUnit));
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testCreateNonFueledVehicle", persistenceUnit));
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testReadFueledVehicle", persistenceUnit));
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testReadNonFueledVehicle", persistenceUnit));
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testNamedNativeQueryOnSportsCar", persistenceUnit));
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testUpdateBusFueledVehicle", persistenceUnit));
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testUpdateFueledVehicle", persistenceUnit));
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testUpdateNonFueledVehicle", persistenceUnit));
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testDeleteBusFueledVehicle", persistenceUnit));
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testDeleteFueledVehicle", persistenceUnit));
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testDeleteNonFueledVehicle", persistenceUnit));
        suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testPKJoinColumnAssociation", persistenceUnit));
        if (persistenceUnit.equals("extended-inheritance")) {
            suite.addTest((Test)new EntityMappingsInheritanceJUnitTestCase("testAppleComputers", persistenceUnit));
        }
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession((String)this.m_persistenceUnit);
        new InheritanceTableCreator().replaceTables((DatabaseSession)session);
        EntityMappingsInheritanceJUnitTestCase.clearCache((String)this.m_persistenceUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppleComputers() {
        EntityManager em = EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        MacBook macBook1 = new MacBook();
        macBook1.setRam(Integer.valueOf(2));
        MacBook macBook2 = new MacBook();
        macBook2.setRam(Integer.valueOf(4));
        MacBookPro macBookPro1 = new MacBookPro();
        macBookPro1.setRam(Integer.valueOf(4));
        macBookPro1.setColor("Black");
        MacBookPro macBookPro2 = new MacBookPro();
        macBookPro2.setRam(Integer.valueOf(6));
        macBookPro2.setColor("Red");
        MacBookPro macBookPro3 = new MacBookPro();
        macBookPro3.setRam(Integer.valueOf(8));
        macBookPro3.setColor("Green");
        MacBookPro macBookPro4 = new MacBookPro();
        macBookPro4.setRam(Integer.valueOf(8));
        macBookPro4.setColor("Blue");
        try {
            em.persist((Object)macBook1);
            em.persist((Object)macBook2);
            em.persist((Object)macBookPro1);
            em.persist((Object)macBookPro2);
            em.persist((Object)macBookPro3);
            em.persist((Object)macBookPro4);
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            EntityMappingsInheritanceJUnitTestCase.fail((String)("Error persisting macbooks: " + exception.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
        EntityMappingsInheritanceJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        em = EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        List macBooks = em.createNamedQuery("findAllXMLMacBooks").getResultList();
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)("The wrong number of mac books were returned: " + macBooks.size() + ", expected: 6"), (macBooks.size() == 6 ? 1 : 0) != 0);
        List macBookPros = em.createNamedQuery("findAllXMLMacBookPros").getResultList();
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)("The wrong number of mac book pros were returned: " + macBookPros.size() + ", expected: 4"), (macBookPros.size() == 4 ? 1 : 0) != 0);
    }

    public void testCreateBusFueledVehicle() {
        int prePersistBusCountBefore = 0;
        int postPersistBusCountBefore = 0;
        int preWriteBusNativeListenerCountBefore = BusNativeListener.PRE_WRITE_COUNT;
        int postWriteBusNativeListenerCountBefore = BusNativeListener.POST_WRITE_COUNT;
        int prePersistBusListenerCountBefore = BusListener.PRE_PERSIST_COUNT;
        int postPersistBusListenerCountBefore = BusListener.POST_PERSIST_COUNT;
        int prePersistBusListener2CountBefore = BusListener2.PRE_PERSIST_COUNT;
        int postPersistBusListener2CountBefore = BusListener2.POST_PERSIST_COUNT;
        int prePersistDefaultListenerCountBefore = DefaultListener.PRE_PERSIST_COUNT;
        int postPersistDefaultListenerCountBefore = DefaultListener.POST_PERSIST_COUNT;
        EntityManager em = EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        Bus bus = new Bus();
        bus.setPassengerCapacity(new Integer(50));
        bus.setFuelCapacity(new Integer(175));
        bus.setDescription("OC Transpo Bus");
        bus.setFuelType("Diesel");
        try {
            em.persist((Object)bus);
            busId = bus.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PrePersist callback method on Bus was not called.", (prePersistBusCountBefore == bus.pre_persist_count ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PostPersist callback method on Bus was not called.", (postPersistBusCountBefore == bus.post_persist_count ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PreWrite callback method (native) on BusNativeListener was not called.", (preWriteBusNativeListenerCountBefore == BusNativeListener.PRE_WRITE_COUNT ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PostWrite callback method (native) on BusNativeListener was not called.", (postWriteBusNativeListenerCountBefore == BusNativeListener.POST_WRITE_COUNT ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PrePersist callback method on BusListener was not called.", (prePersistBusListenerCountBefore == BusListener.PRE_PERSIST_COUNT ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PostPersist callback method on BusListener was not called.", (postPersistBusListenerCountBefore == BusListener.POST_PERSIST_COUNT ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PrePersist callback method on BusListener2 was not called.", (prePersistBusListener2CountBefore == BusListener2.PRE_PERSIST_COUNT ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PostPersist callback method on BusListener2 was not called.", (postPersistBusListener2CountBefore == BusListener2.POST_PERSIST_COUNT ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PrePersist callback method on DefaultListener was not called.", (prePersistDefaultListenerCountBefore == DefaultListener.PRE_PERSIST_COUNT ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PostPersist callback method on DefaultListener was not called.", (postPersistDefaultListenerCountBefore == DefaultListener.POST_PERSIST_COUNT ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"An incorrect number of PrePersist notifications where made for the Bus object.", (bus.prePersistCalledListenerCount() == 6 ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"An incorrect number of PostPersist notifications where made for the Bus object.", (bus.postPersistCalledListenerCount() == 3 ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"The PrePersist events were not fired in the correct order.", (bus.getPrePersistCalledListenerAt(0) == DefaultListener1.class ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"The PrePersist events were not fired in the correct order.", (bus.getPrePersistCalledListenerAt(1) == DefaultListener2.class ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"The PrePersist events were not fired in the correct order.", (bus.getPrePersistCalledListenerAt(2) == DefaultListener3.class ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"The PrePersist events were not fired in the correct order.", (bus.getPrePersistCalledListenerAt(3) == BusListener2.class ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"The PrePersist events were not fired in the correct order.", (bus.getPrePersistCalledListenerAt(4) == BusListener3.class ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"The PrePersist events were not fired in the correct order.", (bus.getPrePersistCalledListenerAt(5) == BusListener.class ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"The PostPersist events were not fired in the correct order.", (bus.getPostPersistCalledListenerAt(0) == BusListener2.class ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"The PostPersist events were not fired in the correct order.", (bus.getPostPersistCalledListenerAt(1) == BusListener3.class ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"The PostPersist events were not fired in the correct order.", (bus.getPostPersistCalledListenerAt(2) == BusListener.class ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateFueledVehicle() {
        EntityManager em = EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            SportsCar car = (SportsCar)InheritanceModelExamples.sportsCarExample1();
            car.setDescription("Ferrari");
            car.setMaxSpeed(300);
            em.persist((Object)car);
            sportsCarId = car.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityMappingsInheritanceJUnitTestCase.fail((String)("An exception was caught during create FueledVehicle [SportsCar] operation : " + e.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateNonFueledVehicle() {
        EntityManager em = EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Company co = InheritanceModelExamples.companyExample2();
            Boat boat = InheritanceModelExamples.boatExample1((Company)co);
            em.persist((Object)boat);
            boatId = boat.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityMappingsInheritanceJUnitTestCase.fail((String)("An exception was caught during create NonFueledVehicle [Boat] operation : " + e.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testDeleteBusFueledVehicle() {
        int postLoadBusCountBefore = 0;
        int preRemoveBusCountBefore = 0;
        int postRemoveBusCountBefore = 0;
        EntityManager em = EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        Bus bus = (Bus)em.find(Bus.class, (Object)busId);
        try {
            em.remove((Object)bus);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"Error deleting FueledVehicle [Bus]", (em.find(Bus.class, (Object)busId) == null ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PostLoad callback method on Bus was not called.", (postLoadBusCountBefore == bus.post_load_count ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PreRemove callback method on Bus was not called.", (preRemoveBusCountBefore == bus.pre_remove_count ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PostRemove callback method on Bus was not called.", (postRemoveBusCountBefore == bus.post_remove_count ? 1 : 0) != 0);
    }

    public void testDeleteFueledVehicle() {
        EntityManager em = EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            em.remove(em.find(SportsCar.class, (Object)sportsCarId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"Error deleting FueledVehicle [SportsCar]", (em.find(SportsCar.class, (Object)sportsCarId) == null ? 1 : 0) != 0);
    }

    public void testDeleteNonFueledVehicle() {
        EntityManager em = EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            em.remove(em.find(Boat.class, (Object)boatId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"Error deleting NonFueledVehicle [Boat]", (em.find(Boat.class, (Object)boatId) == null ? 1 : 0) != 0);
    }

    public void testNamedNativeQueryOnSportsCar() {
        Query query = EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit).createNamedQuery("findSQLMaxSpeedForFerrari");
        List results = query.getResultList();
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"Failed to return 1 item", (results.size() == 1 ? 1 : 0) != 0);
        for (Object maxSpeed : results) {
            EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"Failed to return column", (boolean)(maxSpeed instanceof Number));
            EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"Failed to return correct speed of 300", (((Number)maxSpeed).intValue() == 300 ? 1 : 0) != 0);
        }
    }

    public void testReadFueledVehicle() {
        SportsCar car = (SportsCar)EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit).find(SportsCar.class, (Object)sportsCarId);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"Error reading FueledVehicle [SportsCar]", (car.getId() == sportsCarId ? 1 : 0) != 0);
    }

    public void testReadNonFueledVehicle() {
        Boat boat = (Boat)EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit).find(Boat.class, (Object)boatId);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"Error reading NonFueledVehicle [Boat]", (boat.getId() == boatId ? 1 : 0) != 0);
    }

    public void testUpdateBusFueledVehicle() {
        Bus bus;
        int preUpdateBusCountBefore = 0;
        int postUpdateBusCountBefore = 0;
        EntityManager em = EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            bus = (Bus)em.find(Bus.class, (Object)busId);
            bus.setDescription("A crappy bus");
            em.merge((Object)bus);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PreUpdate callback method on Bus was not called.", (preUpdateBusCountBefore == bus.pre_update_count ? 1 : 0) != 0);
        EntityMappingsInheritanceJUnitTestCase.assertFalse((String)"The PostUpdate callback method on Bus was not called.", (postUpdateBusCountBefore == bus.post_update_count ? 1 : 0) != 0);
        int postLoadBusCountBefore = bus.post_load_count;
        this.beginTransaction(em);
        try {
            bus = (Bus)em.find(Bus.class, (Object)busId);
            EntityMappingsInheritanceJUnitTestCase.clearCache((String)this.m_persistenceUnit);
            em.refresh((Object)bus);
            int postLoadBusCountAfter1 = bus.post_load_count;
            em.refresh((Object)bus);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"Error updating FueledVehicle [Bus]", (boolean)bus.getDescription().equals("A crappy bus"));
    }

    public void testUpdateFueledVehicle() {
        EntityManager em = EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            SportsCar car = (SportsCar)em.find(SportsCar.class, (Object)sportsCarId);
            car.setDescription("Corvette");
            em.merge((Object)car);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsInheritanceJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        SportsCar newCar = (SportsCar)em.find(SportsCar.class, (Object)sportsCarId);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"Error updating FueledVehicle [SportsCar]", (boolean)newCar.getDescription().equals("Corvette"));
    }

    public void testUpdateNonFueledVehicle() {
        EntityManager em = EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Boat boat = (Boat)em.find(Boat.class, (Object)boatId);
            Company co = boat.getOwner();
            co.setName("XYZ");
            em.merge((Object)boat);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsInheritanceJUnitTestCase.clearCache((String)this.m_persistenceUnit);
        Boat newBoat = (Boat)em.find(Boat.class, (Object)boatId);
        EntityMappingsInheritanceJUnitTestCase.assertTrue((String)"Error updating NonFueledVehicle [Boat]", (boolean)newBoat.getOwner().getName().equals("XYZ"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPKJoinColumnAssociation() {
        EntityManager em = EntityMappingsInheritanceJUnitTestCase.createEntityManager((String)this.m_persistenceUnit);
        this.beginTransaction(em);
        try {
            Boat boat = new Boat();
            boat.setModel("Sprint");
            boat.setPassengerCapacity(Integer.valueOf(99));
            em.persist((Object)boat);
            Person person = new Person();
            person.setBoat(boat);
            person.setName("boat owner");
            em.persist((Object)person);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityMappingsInheritanceJUnitTestCase.fail((String)("Error on commit: " + e.getCause()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }
}

